/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.blockiterators.CubicBlockIterator;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.teleport.telepad.DialerFacing;
import crazypants.enderio.machines.machine.teleport.telepad.TileTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketTargetList;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileDialingDevice
extends AbstractCapabilityPoweredMachineEntity
implements IRanged {
    @Store
    private DialerFacing dialerFacing;
    @Store(handler=TelepadTarget.TelepadTargetArrayListHandler.class)
    private final ArrayList<TelepadTarget> targets = new ArrayList();
    private boolean showingRange;
    @Nonnull
    public static final Vector4f RANGE_COLOR = new Vector4f(0.13333334f, 0.45882353f, 0.5058824f, 0.4f);

    public TileDialingDevice() {
        super(CapacitorKey.DIALING_DEVICE_POWER_INTAKE, CapacitorKey.DIALING_DEVICE_POWER_BUFFER, CapacitorKey.DIALING_DEVICE_POWER_USE);
        this.getInventory().add(EnderInventory.Type.INPUT, "INPUT", new InventorySlot(TileTelePad.LOCATION_PRINTOUTS, 1));
        this.getInventory().add(EnderInventory.Type.OUTPUT, "OUTPUT", new InventorySlot(1));
        this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
    }

    @Override
    public boolean processTasks(boolean redstoneCheck) {
        this.getEnergy().useEnergy();
        if (!this.getInventory().getSlot("INPUT").isEmpty() && this.getInventory().getSlot("OUTPUT").isEmpty() && this.getEnergy().useEnergy(CapacitorKey.DIALING_DEVICE_POWER_USE_PAPER)) {
            ItemStack stack = this.getInventory().getSlot("INPUT").get();
            TelepadTarget newTarg = TelepadTarget.readFromNBT(stack);
            if (newTarg != null && !this.targets.contains(newTarg)) {
                this.addTarget(newTarg);
                PacketHandler.sendToAllAround((IMessage)new PacketTargetList(this, newTarg, true), (TileEntity)this);
            }
            this.getInventory().getSlot("INPUT").clear();
            this.getInventory().getSlot("OUTPUT").set(stack);
        }
        return false;
    }

    public void addTarget(TelepadTarget newTarg) {
        if (newTarg == null) {
            return;
        }
        this.targets.add(newTarg);
        this.func_70296_d();
    }

    public void removeTarget(TelepadTarget target) {
        if (target == null) {
            return;
        }
        this.targets.remove(target);
        this.func_70296_d();
    }

    public ArrayList<TelepadTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<TelepadTarget> t) {
        this.targets.clear();
        if (t != null) {
            this.targets.addAll(t);
        }
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Nonnull
    public DialerFacing getDialerFacing() {
        return this.dialerFacing != null ? this.dialerFacing : DialerFacing.DOWN_TONORTH;
    }

    public void setDialerFacing(DialerFacing facing) {
        this.dialerFacing = facing;
        this.func_70296_d();
    }

    @Nullable
    public TileTelePad findTelepad() {
        for (BlockPos check : new CubicBlockIterator(this.getBounds())) {
            TileTelePad result = (TileTelePad)BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.func_145831_w(), (BlockPos)((BlockPos)NullHelper.first((Object[])new BlockPos[]{check, this.field_174879_c})), TileTelePad.class);
            if (result == null) continue;
            return result.getMaster();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileDialingDevice>(this, RANGE_COLOR));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        EnumFacing side;
        EnumFacing up;
        EnumFacing forward = this.getDialerFacing().getInputSide();
        if (forward.func_96559_d() == 0) {
            up = EnumFacing.UP;
            side = forward.func_176746_e();
        } else {
            up = EnumFacing.NORTH;
            side = EnumFacing.EAST;
        }
        int range = 4;
        BlockPos checkMin = this.field_174879_c.func_177967_a(forward, 1).func_177967_a(side, 0 - range).func_177967_a(up, 0 - range);
        BlockPos checkMax = this.field_174879_c.func_177967_a(forward, range * 2 - 1 + 1).func_177967_a(side, range * 2 - 1 - range).func_177967_a(up, range * 2 - 1 - range);
        return new BoundingBox(checkMin, checkMax);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE;
    }

    @Override
    protected void onAfterNbtRead() {
        this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
        super.onAfterNbtRead();
    }
}

