/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.transceiver.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.gui.ListSelectionListener;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.UserIdent;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelType;
import crazypants.enderio.base.transceiver.ClientChannelRegister;
import crazypants.enderio.base.transceiver.PacketAddRemoveChannel;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.transceiver.PacketSendRecieveChannel;
import crazypants.enderio.machines.machine.transceiver.TileTransceiver;
import crazypants.enderio.machines.machine.transceiver.gui.GuiChannelList;
import crazypants.enderio.machines.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChannelTab
implements ITabPanel {
    protected static final int ADD_BUTTON_ID = 3;
    protected static final int PRIVATE_BUTTON_ID = 4;
    private static final int DELETE_CHANNEL_BUTTON_ID = 5;
    private static final int SEND_BUTTON_ID = 6;
    private static final int RECIEVE_BUTTON_ID = 7;
    @Nonnull
    final ChannelType type;
    @Nonnull
    final GuiTransceiver parent;
    @Nonnull
    final IconButton addButton;
    @Nonnull
    final ToggleButton privateButton;
    @Nonnull
    final GuiTextField newChannelTF;
    @Nonnull
    final GuiChannelList channelList;
    @Nonnull
    final GuiChannelList sendChannels;
    @Nonnull
    final GuiChannelList recieveChannels;
    @Nonnull
    final IconButton deleteChannelB;
    @Nonnull
    final IconButton sendB;
    @Nonnull
    final IconButton recieveB;
    @Nonnull
    final ListSelectionListener<Channel> selectionListener;
    @Nonnull
    final TileTransceiver transceiver;
    @Nonnull
    final SendReceivePredicate predicate;

    public ChannelTab(@Nonnull GuiTransceiver guiTransceiver, @Nonnull ChannelType type) {
        this.parent = guiTransceiver;
        this.type = type;
        this.transceiver = guiTransceiver.getTransciever();
        this.newChannelTF = new GuiTextField(76543, this.parent.getFontRenderer(), 7, 12, 103, 16);
        this.addButton = new IconButton((IGuiScreen)this.parent, 3, 137, 12, (IWidgetIcon)IconEIO.PLUS);
        this.addButton.setToolTip(new String[]{Lang.GUI_TRANS_CHANNEL_ADD.get()});
        this.addButton.field_146124_l = false;
        this.privateButton = new ToggleButton((IGuiScreen)this.parent, 4, 118, 12, (IWidgetIcon)IconEIO.LOCK_UNLOCKED, (IWidgetIcon)IconEIO.LOCK_LOCKED);
        this.privateButton.setSelectedToolTip(new String[]{Lang.GUI_TRANS_CHANNEL_PRIVATE.get()});
        this.privateButton.setUnselectedToolTip(new String[]{Lang.GUI_TRANS_CHANNEL_PUBLIC.get()});
        int w = 104;
        int h = 90;
        int x = 7;
        int y = 48;
        this.channelList = new GuiChannelList(this.parent, w, h, x, y);
        this.channelList.setChannels(ClientChannelRegister.instance.getChannelsForType(type), (Predicate<Channel>)Predicates.alwaysTrue());
        this.channelList.setShowSelectionBox(true);
        this.channelList.setScrollButtonIds(100, 101);
        this.deleteChannelB = new IconButton((IGuiScreen)this.parent, 5, x + w - 20, y + h + 4, (IWidgetIcon)IconEIO.MINUS);
        this.deleteChannelB.setToolTip(new String[]{Lang.GUI_TRANS_CHANNEL_DELETE.get()});
        this.predicate = new SendReceivePredicate();
        h = 35;
        this.sendChannels = new GuiChannelList(this.parent, w, h, x += w + 32, y);
        this.sendChannels.setChannels(this.transceiver.getSendChannels(type), this.predicate);
        this.sendChannels.setShowSelectionBox(true);
        this.sendChannels.setScrollButtonIds(200, 201);
        this.sendB = new IconButton((IGuiScreen)this.parent, 6, x - 24, y + h / 2 - 9, (IWidgetIcon)IconEIO.ARROWS);
        this.recieveChannels = new GuiChannelList(this.parent, w, h, x, y += h + 20);
        this.recieveChannels.setChannels(this.transceiver.getRecieveChannels(type), this.predicate);
        this.recieveChannels.setShowSelectionBox(true);
        this.recieveChannels.setScrollButtonIds(300, 301);
        this.recieveB = new IconButton((IGuiScreen)this.parent, 7, x - 24, y + h / 2 - 9, (IWidgetIcon)IconEIO.ARROWS);
        this.selectionListener = new ListSelectionListener<Channel>(){

            public void selectionChanged(@Nonnull GuiScrollableList<Channel> list, int selectedIndex) {
                if (selectedIndex < 0) {
                    return;
                }
                if (list != ChannelTab.this.channelList) {
                    ChannelTab.this.channelList.setSelection(-1);
                }
                if (list != ChannelTab.this.sendChannels) {
                    ChannelTab.this.sendChannels.setSelection(-1);
                }
                if (list != ChannelTab.this.recieveChannels) {
                    ChannelTab.this.recieveChannels.setSelection(-1);
                }
            }
        };
        this.channelList.addSelectionListener(this.selectionListener);
        this.sendChannels.addSelectionListener(this.selectionListener);
        this.recieveChannels.addSelectionListener(this.selectionListener);
    }

    public void onGuiInit(int x, int y, int width, int height) {
        this.addButton.onGuiInit();
        this.privateButton.onGuiInit();
        this.deleteChannelB.onGuiInit();
        this.sendB.onGuiInit();
        this.recieveB.onGuiInit();
        y = this.parent.getGuiTop() + 12;
        this.newChannelTF.field_146209_f = x = this.parent.getGuiLeft() + 8;
        this.newChannelTF.field_146210_g = y;
        this.newChannelTF.func_146205_d(false);
        this.newChannelTF.func_146203_f(32);
        this.newChannelTF.func_146195_b(true);
        this.channelList.onGuiInit((IGuiScreen)this.parent);
        this.sendChannels.onGuiInit((IGuiScreen)this.parent);
        this.recieveChannels.onGuiInit((IGuiScreen)this.parent);
    }

    public void deactivate() {
        this.addButton.detach();
        this.privateButton.detach();
        this.deleteChannelB.detach();
        this.sendB.detach();
        this.recieveB.detach();
    }

    public void keyTyped(char par1, int par2) {
        this.newChannelTF.func_146201_a(par1, par2);
        this.addButton.field_146124_l = this.newChannelTF.func_146179_b().trim().length() > 0;
    }

    @Nonnull
    public IconEIO getIcon() {
        switch (this.type) {
            case FLUID: {
                return IconEIO.WRENCH_OVERLAY_FLUID;
            }
            case ITEM: {
                return IconEIO.WRENCH_OVERLAY_ITEM;
            }
            case POWER: {
                return IconEIO.WRENCH_OVERLAY_POWER;
            }
        }
        return IconEIO.WRENCH_OVERLAY_POWER;
    }

    public void updateScreen() {
        this.newChannelTF.func_146178_a();
    }

    public void render(float partialTick, int mouseX, int mouseY) {
        this.newChannelTF.func_146194_f();
        this.channelList.drawScreen(mouseX, mouseY, partialTick);
        this.sendChannels.drawScreen(mouseX, mouseY, partialTick);
        this.recieveChannels.drawScreen(mouseX, mouseY, partialTick);
        int left = this.parent.getGuiLeft();
        int top = this.parent.getGuiTop();
        int x = left + 59;
        int y = top + 36;
        this.parent.func_73732_a(this.parent.getFontRenderer(), Lang.GUI_TRANS_AVAILABLE.get(), x, y, ColorUtil.getRGB((Color)Color.white));
        x = left + 199;
        this.parent.func_73732_a(this.parent.getFontRenderer(), Lang.GUI_TRANS_SEND.get(), x, y, ColorUtil.getRGB((Color)Color.white));
        this.parent.func_73732_a(this.parent.getFontRenderer(), Lang.GUI_TRANS_RECEIVE.get(), x, y += 56, ColorUtil.getRGB((Color)Color.white));
    }

    public void actionPerformed(@Nonnull GuiButton guiButton) {
        if (guiButton.field_146127_k == 3) {
            this.addChannelPressed();
        } else if (guiButton.field_146127_k == 5) {
            this.deleteChannelPressed();
        } else if (guiButton.field_146127_k == 6) {
            this.sendTogglePressed();
        } else if (guiButton.field_146127_k == 7) {
            this.receiveTogglePressed();
        }
    }

    protected void receiveTogglePressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null && !this.transceiver.getRecieveChannels(this.type).contains(c)) {
            this.transceiver.addRecieveChanel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, false, true, c));
        } else {
            c = (Channel)this.recieveChannels.getSelectedElement();
            if (c != null) {
                this.transceiver.removeRecieveChanel(c);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, false, false, c));
            }
        }
        this.recieveChannels.setChannels(this.transceiver.getRecieveChannels(this.type), this.predicate);
    }

    protected void sendTogglePressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null && !this.transceiver.getSendChannels(this.type).contains(c)) {
            this.transceiver.addSendChanel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, true, true, c));
        } else {
            c = (Channel)this.sendChannels.getSelectedElement();
            if (c != null) {
                this.transceiver.removeSendChanel(c);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, true, false, c));
            }
        }
        this.sendChannels.setChannels(this.transceiver.getSendChannels(this.type), this.predicate);
    }

    private void deleteChannelPressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null) {
            ClientChannelRegister.instance.removeChannel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(c, false));
        }
    }

    private void addChannelPressed() {
        if (this.newChannelTF.func_146179_b().trim().isEmpty()) {
            return;
        }
        Channel c = this.privateButton.isSelected() ? new Channel(this.newChannelTF.func_146179_b(), Minecraft.func_71410_x().field_71439_g.func_146103_bH(), this.type) : new Channel(this.newChannelTF.func_146179_b(), this.type);
        ClientChannelRegister.instance.addChannel(c);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(c, true));
        this.channelList.setSelection(c);
        this.newChannelTF.func_146180_a("");
    }

    public void mouseClicked(int x, int y, int par3) {
        this.newChannelTF.func_146192_a(x, y, par3);
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return EnderIO.proxy.getGuiTexture("transceiver_channel_select");
    }

    private class SendReceivePredicate
    implements Predicate<Channel> {
        private SendReceivePredicate() {
        }

        public boolean apply(@Nullable Channel input) {
            return input != null && (input.isPublic() || input.getUser().equals(EnderIO.proxy.getClientPlayer().func_146103_bH()) || input.getUser() == UserIdent.NOBODY);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

