/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.property.IOMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.powertools.machine.capbank.BlockItemCapBank;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.ContainerCapBank;
import crazypants.enderio.powertools.machine.capbank.GuiCapBank;
import crazypants.enderio.powertools.machine.capbank.InfoDisplayType;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkUtil;
import crazypants.enderio.powertools.machine.capbank.render.CapBankBlockRenderMapper;
import crazypants.enderio.powertools.machine.capbank.render.CapBankItemRenderMapper;
import crazypants.enderio.powertools.machine.capbank.render.CapBankRenderer;
import crazypants.enderio.util.Prep;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCapBank
extends BlockEio<TileCapBank>
implements IEioGuiHandler.WithPos,
IAdvancedTooltipProvider,
ISmartRenderAwareBlock,
IHaveTESR,
ICustomSubItems,
IPaintable.ISolidBlockPaintableBlock {
    private static final TextureRegistry.TextureSupplier gaugeIcon = TextureRegistry.registerTexture("blocks/capacitor_bank_overlays");
    private static final TextureRegistry.TextureSupplier infoPanelIcon = TextureRegistry.registerTexture("blocks/cap_bank_info_panel");

    public static BlockCapBank create(@Nonnull IModObject modObject) {
        BlockCapBank res = new BlockCapBank(modObject);
        res.init();
        return res;
    }

    protected BlockCapBank(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149711_c(2.0f);
        this.func_149713_g(255);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)).func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.NONE)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    public ItemBlock createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemCapBank(this));
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER, CapBankType.KIND});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return CapBankType.getMetaFromType((CapBankType)((Object)state.func_177229_b(CapBankType.KIND)));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        CapBankBlockRenderMapper renderMapper = new CapBankBlockRenderMapper(state, world, pos);
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
        blockStateWrapper.addCacheKey(state.func_177229_b(CapBankType.KIND));
        blockStateWrapper.addCacheKey(renderMapper);
        TileCapBank tileEntity = (TileCapBank)this.getTileEntitySafe(world, pos);
        if (tileEntity != null) {
            for (EnumFacing face : EnumFacing.values()) {
                blockStateWrapper.addCacheKey((Object)tileEntity.getIoMode((EnumFacing)NullHelper.notnullJ((Object)face, (String)"Enum.values()")));
                blockStateWrapper.addCacheKey((Object)tileEntity.getDisplayType(face));
            }
        }
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, CapBankType.values().length - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs p_149666_2_, @Nonnull NonNullList<ItemStack> list) {
        for (CapBankType type : CapBankType.types()) {
            if (type.isCreative()) {
                list.add((Object)BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), type.getMaxEnergyStored() / 2));
                continue;
            }
            list.add((Object)BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), 0));
            list.add((Object)BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), type.getMaxEnergyStored()));
        }
    }

    public int func_180651_a(@Nonnull IBlockState st) {
        return this.func_176201_c(st);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(LangPower.RF(BlockItemCapBank.getStoredEnergyForItem(itemstack), CapBankType.getTypeFromMeta(itemstack.func_77952_i()).getMaxEnergyStored()));
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing faceHit, float hitX, float hitY, float hitZ) {
        TileCapBank tcb = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (tcb == null) {
            return false;
        }
        if (entityPlayer.func_70093_af() && Prep.isInvalid(entityPlayer.func_184586_b(hand)) && faceHit.func_96559_d() == 0) {
            InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
            if (newDisplayType == InfoDisplayType.NONE) {
                tcb.setDefaultIoMode(faceHit);
            } else {
                tcb.setIoMode(faceHit, IoMode.DISABLED);
            }
            tcb.setDisplayType(faceHit, newDisplayType);
            return true;
        }
        if (!entityPlayer.func_70093_af() && ToolUtil.isToolEquipped(entityPlayer, hand)) {
            IoMode ioMode = tcb.getIoMode(faceHit);
            if (faceHit.func_96559_d() == 0) {
                if (ioMode == IoMode.DISABLED) {
                    InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
                    tcb.setDisplayType(faceHit, newDisplayType);
                    if (newDisplayType == InfoDisplayType.NONE) {
                        tcb.toggleIoModeForFace(faceHit);
                    }
                } else {
                    tcb.toggleIoModeForFace(faceHit);
                }
            } else {
                tcb.toggleIoModeForFace(faceHit);
            }
            if (!world.field_72995_K) {
                world.func_175685_c(pos, (Block)this, true);
            }
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, faceHit, hitX, hitY, hitZ);
    }

    @Override
    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        return this.openGui(world, pos, entityPlayer, side, BlockCapBank.baublesToGuiId(BaublesUtil.instance().getBaubles(entityPlayer)));
    }

    private static int baublesToGuiId(IInventory baubles) {
        if (baubles != null && baubles.func_70302_i_() == 4) {
            return 4;
        }
        if (baubles != null && baubles.func_70302_i_() == 7) {
            return 7;
        }
        return 0;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return new ContainerCapBank(player.field_71071_by, te);
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return new GuiCapBank((Entity)player, player.field_71071_by, te, new ContainerCapBank(player.field_71071_by, te));
        }
        return null;
    }

    public boolean isSideSolid(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean func_176225_a(@Nonnull IBlockState bs, @Nonnull IBlockAccess par1IBlockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        Block i1 = par1IBlockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return i1 == this ? false : super.func_176225_a(bs, par1IBlockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public static TextureAtlasSprite getGaugeIcon() {
        return gaugeIcon.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public static TextureAtlasSprite getInfoPanelIcon() {
        return infoPanelIcon.get(TextureAtlasSprite.class);
    }

    @Deprecated
    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos) {
        if (world.field_72995_K) {
            return;
        }
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborBlockChange(neighborBlock);
        }
    }

    public int func_149745_a(@Nonnull Random r) {
        return 0;
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull TileCapBank te) {
        super.onBlockPlaced(world, pos, state, player, (TileEntityBase)te);
        Collection<TileCapBank> neigbours = NetworkUtil.getNeigbours(te);
        if (neigbours.isEmpty()) {
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            EnumFacing dir = this.getDirForHeading(heading);
            te.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
        } else {
            boolean modifiedDisplayType = this.setDisplayToVerticalFillBar(te, (TileCapBank)this.getTileEntity((IBlockAccess)world, pos.func_177977_b()));
            if (modifiedDisplayType |= this.setDisplayToVerticalFillBar(te, (TileCapBank)this.getTileEntity((IBlockAccess)world, pos.func_177984_a()))) {
                te.validateDisplayTypes();
            }
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_184138_a(pos, state, state, 3);
    }

    protected boolean setDisplayToVerticalFillBar(TileCapBank cb, TileCapBank capBank) {
        boolean modifiedDisplayType = false;
        if (capBank != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.func_96559_d() != 0 || capBank.getDisplayType(dir) != InfoDisplayType.LEVEL_BAR || capBank.getType() != cb.getType()) continue;
                cb.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
                modifiedDisplayType = true;
            }
        }
        return modifiedDisplayType;
    }

    protected EnumFacing getDirForHeading(int heading) {
        switch (heading) {
            case 0: {
                return EnumFacing.values()[2];
            }
            case 1: {
                return EnumFacing.values()[5];
            }
            case 2: {
                return EnumFacing.values()[3];
            }
        }
        return EnumFacing.values()[4];
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    @Nonnull
    public AxisAlignedBB func_180640_a(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        TileCapBank tr = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (tr == null) {
            return super.func_180640_a(bs, world, pos);
        }
        ICapBankNetwork network = tr.getNetwork();
        if (!tr.getType().isMultiblock() || network == null) {
            return super.func_180640_a(bs, world, pos);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (TileCapBank bc : network.getMembers()) {
            int x = bc.func_174877_v().func_177958_n();
            int y = bc.func_174877_v().func_177956_o();
            int z = bc.func_174877_v().func_177952_p();
            min.x = Math.min(min.x, (double)x);
            max.x = Math.max(max.x, (double)(x + 1));
            min.y = Math.min(min.y, (double)y);
            max.y = Math.max(max.y, (double)(y + 1));
            min.z = Math.min(min.z, (double)z);
            max.z = Math.max(max.z, (double)(z + 1));
        }
        return new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public boolean func_149740_M(@Nonnull IBlockState bs) {
        return true;
    }

    public int func_180641_l(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.getComparatorOutput();
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public CapBankItemRenderMapper getItemRenderMapper() {
        return CapBankItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IOMode.EnumIOMode mapIOMode(InfoDisplayType displayType, IoMode mode) {
        switch (displayType) {
            case IO: {
                return IOMode.EnumIOMode.CAPACITORBANK;
            }
            case LEVEL_BAR: {
                switch (mode) {
                    case NONE: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANKINPUTSMALL;
                    }
                    case PUSH: {
                        return IOMode.EnumIOMode.CAPACITORBANKOUTPUTSMALL;
                    }
                    case PUSH_PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case DISABLED: {
                        return IOMode.EnumIOMode.CAPACITORBANKLOCKEDSMALL;
                    }
                }
            }
            case NONE: {
                switch (mode) {
                    case NONE: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANKINPUT;
                    }
                    case PUSH: {
                        return IOMode.EnumIOMode.CAPACITORBANKOUTPUT;
                    }
                    case PUSH_PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case DISABLED: {
                        return IOMode.EnumIOMode.CAPACITORBANKLOCKED;
                    }
                }
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCapBank.class, (TileEntitySpecialRenderer)new CapBankRenderer((Block)this));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

