/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.powertools.config.CapBankConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public enum CapBankType implements IStringSerializable
{
    CREATIVE("CREATIVE", "tile.block_cap_bank.creative", CapBankConfig.tierC_maxIO, CapBankConfig.tierC_maxStorage, false, true),
    SIMPLE("SIMPLE", "tile.block_cap_bank.simple", CapBankConfig.tier1_maxIO, CapBankConfig.tier1_maxStorage, true, false),
    ACTIVATED("ACTIVATED", "tile.block_cap_bank.activated", CapBankConfig.tier2_maxIO, CapBankConfig.tier2_maxStorage, true, false),
    VIBRANT("VIBRANT", "tile.block_cap_bank.vibrant", CapBankConfig.tier3_maxIO, CapBankConfig.tier3_maxStorage, true, false),
    NONE("NONE", "tile.block_cap_bank.none", CapBankConfig.tierC_maxIO, CapBankConfig.tierC_maxStorage, false, true);

    @Nonnull
    public static final PropertyEnum<CapBankType> KIND;
    @Nonnull
    private final String uid;
    @Nonnull
    private final String unlocalizedName;
    @Nonnull
    private final IValue<Integer> maxIO;
    @Nonnull
    private final IValue<Integer> maxStored;
    private final boolean isMultiblock;
    private final boolean isCreative;

    @Nonnull
    public static List<CapBankType> types() {
        ArrayList<CapBankType> result = new ArrayList<CapBankType>();
        for (CapBankType capBankType : CapBankType.values()) {
            if (capBankType == NONE) continue;
            result.add(capBankType);
        }
        return result;
    }

    public static int getMetaFromType(CapBankType type) {
        return type == null ? 0 : type.ordinal();
    }

    @Nonnull
    public static CapBankType getTypeFromMeta(int meta) {
        return (CapBankType)((Object)NullHelper.notnullJ((Object)((Object)CapBankType.values()[meta >= 0 && meta < CapBankType.values().length ? meta : 0]), (String)"Enum.values()"));
    }

    @Nonnull
    public static CapBankType getTypeFromUID(String uid) {
        for (CapBankType type : CapBankType.values()) {
            if (!type.uid.equals(uid)) continue;
            return type;
        }
        return ACTIVATED;
    }

    private CapBankType(@Nonnull String uid, @Nonnull String unlocalizedName, IValue<Integer> maxIO, IValue<Integer> maxStored, boolean isMultiblock, boolean isCreative) {
        this.uid = uid;
        this.unlocalizedName = unlocalizedName;
        this.maxIO = maxIO;
        this.maxStored = maxStored;
        this.isMultiblock = isMultiblock;
        this.isCreative = isCreative;
    }

    public int getMaxIO() {
        return this.maxIO.get();
    }

    public int getMaxEnergyStored() {
        return this.maxStored.get();
    }

    public boolean isMultiblock() {
        return this.isMultiblock;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Nonnull
    public String getUid() {
        return this.uid;
    }

    @Nonnull
    public String func_176610_l() {
        return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
    }

    static {
        KIND = (PropertyEnum)NullHelper.notnullM((Object)PropertyEnum.func_177709_a((String)"kind", CapBankType.class), (String)"PropertyEnum.create()");
    }
}

