/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.packet;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.powertools.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkState;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNetworkStateResponse
implements IMessage {
    private int id;
    private NetworkState state;

    public PacketNetworkStateResponse() {
    }

    public PacketNetworkStateResponse(@Nonnull ICapBankNetwork network) {
        this(network, false);
    }

    public PacketNetworkStateResponse(@Nonnull ICapBankNetwork network, boolean remove) {
        this.id = network.getId();
        this.state = !remove ? network.getState() : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.state != null);
        if (this.state != null) {
            this.state.writeToBuf(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        boolean hasState = buf.readBoolean();
        this.state = hasState ? NetworkState.readFromBuf(buf) : null;
    }

    public static class Handler
    implements IMessageHandler<PacketNetworkStateResponse, IMessage> {
        public IMessage onMessage(PacketNetworkStateResponse message, MessageContext ctx) {
            if (message.state != null) {
                ClientNetworkManager.getInstance().updateState(EnderIO.proxy.getClientWorld(), message.id, message.state);
            } else {
                ClientNetworkManager.getInstance().destroyNetwork(message.id);
            }
            return null;
        }
    }
}

