/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.NullHelper;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Reader {
    public static <T> void read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) {
        try {
            StorableEngine.read(registry, phase, tag, object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void read(@Nullable Set<NBTAction> phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set)NullHelper.notnull(phase, (String)"Missing phase"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), object);
    }

    public static <T> void read(@Nonnull Registry registry, @Nonnull NBTAction phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(registry, (Set)NullHelper.notnullJ(EnumSet.of(phase), (String)"EnumSet.of()"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), object);
    }

    public static <T> void read(@Nonnull NBTAction phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set)NullHelper.notnullJ(EnumSet.of(phase), (String)"EnumSet.of()"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), object);
    }

    public static <T> void read(@Nonnull Registry registry, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(registry, (Set)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), (String)"EnumSet.allOf()"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), object);
    }

    public static <T> void read(@Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), (String)"EnumSet.allOf()"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), object);
    }

    public static <T> T readField(@Nullable NBTTagCompound tag, @Nullable Class<T> fieldClass, @Nullable String fieldName, @Nullable T object) {
        try {
            return StorableEngine.getSingleField(Registry.GLOBAL_REGISTRY, (Set)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), (String)"EnumSet.allOf()"), (NBTTagCompound)NullHelper.notnull((Object)tag, (String)"Missing NBT"), (String)NullHelper.notnull((Object)fieldName, (String)"Missing field name"), (Class)NullHelper.notnull(fieldClass, (String)"Missing field class"), object);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

