/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.enderio;

import com.enderio.core.common.NBTAction;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelList;
import crazypants.enderio.base.transceiver.ChannelType;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.internal.HandleStorable;
import info.loenwind.autosave.handlers.java.HandleAbstractCollection;
import info.loenwind.autosave.handlers.java.HandleAbstractEnumMap;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class HandleChannelList
extends HandleAbstractEnumMap<ChannelType, Set<Channel>> {
    public HandleChannelList() {
        super(ChannelType.class, new HandleAbstractCollection<Channel, Set<Channel>>(new HandleStorable()){

            @Override
            @Nonnull
            protected Set<Channel> makeCollection() {
                return new HashSet<Channel>();
            }

            @Override
            @Nullable
            protected Channel makeEmptyValueObject() {
                return new Channel("(internal error)", ChannelType.ITEM);
            }
        });
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return ChannelList.class.isAssignableFrom(clazz);
    }

    @Override
    @Nonnull
    protected EnumMap<ChannelType, Set<Channel>> makeMap() {
        return new ChannelList();
    }

    @Override
    public EnumMap<ChannelType, Set<Channel>> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable EnumMap<ChannelType, Set<Channel>> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if ((object = super.read(registry, phase, nbt, field, name, object)) != null) {
            for (Map.Entry<ChannelType, Set<Channel>> entry : object.entrySet()) {
                Iterator<Channel> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    iterator.remove();
                }
            }
        }
        return object;
    }
}

