/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain.lost;

import java.util.Random;
import mcjty.rftoolsdim.config.LostCityConfiguration;

public class City {
    private static boolean isCityCenter(long seed, int chunkX, int chunkZ) {
        Random rand = new Random(seed + (long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        return rand.nextFloat() < LostCityConfiguration.CITY_CHANCE;
    }

    private static float getCityRadius(long seed, int chunkX, int chunkZ) {
        Random rand = new Random(seed + (long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        return LostCityConfiguration.CITY_MINRADIUS + rand.nextInt(LostCityConfiguration.CITY_MAXRADIUS - LostCityConfiguration.CITY_MINRADIUS);
    }

    public static float getCityFactor(long seed, int chunkX, int chunkZ) {
        float factor = 0.0f;
        int offset = (LostCityConfiguration.CITY_MAXRADIUS + 15) / 16;
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                float radius;
                float sqdist;
                if (!City.isCityCenter(seed, cx, cz) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(seed, cx, cz)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                factor += (radius - dist) / radius;
            }
        }
        return factor;
    }
}

