/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.network.SyncDimensionInfoHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncDimensionInfo
implements IMessage {
    private Map<Integer, DimensionDescriptor> dimensions;
    private Map<Integer, DimensionInformation> dimensionInformation;

    public void fromBytes(ByteBuf buf) {
        int id;
        int i;
        int size = buf.readInt();
        this.dimensions = new HashMap<Integer, DimensionDescriptor>();
        for (i = 0; i < size; ++i) {
            NBTTagCompound tagCompound;
            id = buf.readInt();
            PacketBuffer buffer = new PacketBuffer(buf);
            try {
                tagCompound = buffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
            this.dimensions.put(id, descriptor);
        }
        size = buf.readInt();
        this.dimensionInformation = new HashMap<Integer, DimensionInformation>();
        for (i = 0; i < size; ++i) {
            id = buf.readInt();
            String name = NetworkTools.readString((ByteBuf)buf);
            DimensionInformation dimInfo = new DimensionInformation(name, this.dimensions.get(id), buf);
            this.dimensionInformation.put(id, dimInfo);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensions.size());
        for (Map.Entry<Integer, DimensionDescriptor> entry : this.dimensions.entrySet()) {
            buf.writeInt(entry.getKey().intValue());
            NBTTagCompound tagCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(tagCompound);
            PacketBuffer buffer = new PacketBuffer(buf);
            buffer.func_150786_a(tagCompound);
        }
        buf.writeInt(this.dimensionInformation.size());
        for (Map.Entry<Integer, Object> entry : this.dimensionInformation.entrySet()) {
            buf.writeInt(entry.getKey().intValue());
            DimensionInformation dimInfo = (DimensionInformation)entry.getValue();
            NetworkTools.writeString((ByteBuf)buf, (String)dimInfo.getName());
            dimInfo.toBytes(buf);
        }
    }

    public PacketSyncDimensionInfo() {
    }

    public PacketSyncDimensionInfo(Map<Integer, DimensionDescriptor> dimensions, Map<Integer, DimensionInformation> dimensionInformation) {
        this.dimensions = new HashMap<Integer, DimensionDescriptor>(dimensions);
        this.dimensionInformation = new HashMap<Integer, DimensionInformation>(dimensionInformation);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncDimensionInfo, IMessage> {
        public IMessage onMessage(PacketSyncDimensionInfo message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> SyncDimensionInfoHelper.syncDimensionManagerFromServer(message.dimensions, message.dimensionInformation));
            return null;
        }
    }
}

