/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u0002J\u0015\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0015H\u0004J\u0010\u0010A\u001a\u0002082\u0006\u0010@\u001a\u00020\u0015H&R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u001c@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000b\"\u0004\b)\u0010\rR\u001a\u0010*\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001f\"\u0004\b,\u0010!R$\u0010.\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u00103\u001a\u0004\b1\u00102R\u001a\u00104\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001f\"\u0004\b6\u0010!\u00a8\u0006B"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/Animation;", "T", "", "target", "property", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "<set-?>", "", "_id", "get_id$librarianlib_1_12_2", "()I", "set_id", "(I)V", "completion", "Ljava/lang/Runnable;", "getCompletion", "()Ljava/lang/Runnable;", "setCompletion", "(Ljava/lang/Runnable;)V", "duration", "", "getDuration", "()F", "setDuration", "(F)V", "end", "getEnd", "", "finished", "getFinished", "()Z", "setFinished$librarianlib_1_12_2", "(Z)V", "isInAnimator", "isTimeRelative", "setTimeRelative", "getProperty", "()Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "repeatCount", "getRepeatCount", "setRepeatCount", "shouldReverse", "getShouldReverse", "setShouldReverse", "value", "start", "getStart", "setStart", "getTarget", "()Ljava/lang/Object;", "Ljava/lang/Object;", "terminated", "getTerminated", "setTerminated", "complete", "", "doesInvolveObject", "obj", "onAddedToAnimator", "animator", "Lcom/teamwizardry/librarianlib/features/animator/Animator;", "onAddedToAnimator$librarianlib_1_12_2", "timeFraction", "time", "update", "librarianlib-1.12.2"})
public abstract class Animation<T> {
    private boolean isTimeRelative;
    private float start;
    private float duration;
    private boolean shouldReverse;
    private int repeatCount;
    @NotNull
    private Runnable completion;
    private boolean terminated;
    private boolean finished;
    private int _id;
    @NotNull
    private final T target;
    @NotNull
    private final AnimatableProperty<T> property;

    public final boolean isTimeRelative() {
        return this.isTimeRelative;
    }

    public final void setTimeRelative(boolean bl) {
        this.isTimeRelative = bl;
    }

    public final float getStart() {
        return this.start;
    }

    public final void setStart(float value) {
        if (this.isInAnimator()) {
            throw (Throwable)new IllegalStateException("Cannot change the start time of an animation once it has been added to an animator");
        }
        this.start = value;
    }

    public final float getDuration() {
        return this.duration;
    }

    public final void setDuration(float f) {
        this.duration = f;
    }

    public final float getEnd() {
        if (this.repeatCount < 0) {
            return FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        }
        float duration = this.duration;
        if (this.shouldReverse) {
            duration *= (float)2;
        }
        if (this.repeatCount > 0) {
            duration *= (float)this.repeatCount;
        }
        return this.start + duration;
    }

    public final boolean getShouldReverse() {
        return this.shouldReverse;
    }

    public final void setShouldReverse(boolean bl) {
        this.shouldReverse = bl;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    @NotNull
    public final Runnable getCompletion() {
        return this.completion;
    }

    public final void setCompletion(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"<set-?>");
        this.completion = runnable;
    }

    protected final float timeFraction(float time) {
        if (time < this.start) {
            return 0.0f;
        }
        if (time > this.getEnd()) {
            return this.shouldReverse ? 0.0f : 1.0f;
        }
        if (this.shouldReverse) {
            float f = (time - this.start) / this.duration % (float)2;
            if (f > 1.0f) {
                return CommonUtilMethods.clamp((float)2 - f, 0.0f, 1.0f);
            }
            return CommonUtilMethods.clamp(f, 0.0f, 1.0f);
        }
        float f = (time - this.start) / this.duration;
        if (this.repeatCount != 0 && this.repeatCount != 1) {
            f %= 1.0f;
        }
        return CommonUtilMethods.clamp(f, 0.0f, 1.0f);
    }

    public final boolean doesInvolveObject(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (this.target == obj) {
            return true;
        }
        return this.property.doesInvolve(this.target, obj);
    }

    public final boolean isInAnimator() {
        return this._id != -1;
    }

    public abstract void update(float var1);

    public final void complete() {
        this.completion.run();
        this.finished = true;
    }

    public final boolean getTerminated() {
        return this.terminated;
    }

    public final void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished$librarianlib_1_12_2(boolean bl) {
        this.finished = bl;
    }

    public final void onAddedToAnimator$librarianlib_1_12_2(@NotNull Animator animator2) {
        Intrinsics.checkParameterIsNotNull((Object)animator2, (String)"animator");
        if (this.isTimeRelative) {
            Animation animation = this;
            animation.setStart(animation.start + animator2.getTime());
        }
        Animator animator3 = animator2;
        int n = animator3.getNextID$librarianlib_1_12_2();
        animator3.setNextID$librarianlib_1_12_2(n + 1);
        this._id = n;
    }

    public final int get_id$librarianlib_1_12_2() {
        return this._id;
    }

    private final void set_id(int n) {
        this._id = n;
    }

    @NotNull
    public final T getTarget() {
        return this.target;
    }

    @NotNull
    public final AnimatableProperty<T> getProperty() {
        return this.property;
    }

    public Animation(@NotNull T target, @NotNull AnimatableProperty<T> property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this.target = target;
        this.property = property;
        this.isTimeRelative = true;
        this.completion = completion.1.INSTANCE;
        this._id = -1;
    }
}

