/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.interpolate.position;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0013\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/math/interpolate/position/InterpHelix;", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "Lnet/minecraft/util/math/Vec3d;", "point1", "point2", "radius1", "", "radius2", "rotations", "offset", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;FFFF)V", "norm", "kotlin.jvm.PlatformType", "getOffset", "()F", "perpX", "perpY", "getPoint1", "()Lnet/minecraft/util/math/Vec3d;", "getPoint2", "getRadius1", "getRadius2", "getRotations", "get", "i", "librarianlib-1.12.2"})
public final class InterpHelix
implements InterpFunction<Vec3d> {
    private final Vec3d norm;
    private final Vec3d perpX;
    private final Vec3d perpY;
    @NotNull
    private final Vec3d point1;
    @NotNull
    private final Vec3d point2;
    private final float radius1;
    private final float radius2;
    private final float rotations;
    private final float offset;

    @Override
    @NotNull
    public Vec3d get(float i) {
        float t = i * this.rotations + this.offset;
        float radius = this.radius1 + (this.radius2 - this.radius1) * i;
        float x = radius * MathHelper.func_76134_b((float)((float)((double)(t * (float)2) * Math.PI)));
        float y = radius * MathHelper.func_76126_a((float)((float)((double)(t * (float)2) * Math.PI)));
        return CommonUtilMethods.plus(CommonUtilMethods.plus(CommonUtilMethods.plus(this.point1, CommonUtilMethods.times(CommonUtilMethods.minus(this.point2, this.point1), i)), CommonUtilMethods.times(this.perpX, x)), CommonUtilMethods.times(this.perpY, y));
    }

    @NotNull
    public final Vec3d getPoint1() {
        return this.point1;
    }

    @NotNull
    public final Vec3d getPoint2() {
        return this.point2;
    }

    public final float getRadius1() {
        return this.radius1;
    }

    public final float getRadius2() {
        return this.radius2;
    }

    public final float getRotations() {
        return this.rotations;
    }

    public final float getOffset() {
        return this.offset;
    }

    public InterpHelix(@NotNull Vec3d point1, @NotNull Vec3d point2, float radius1, float radius2, float rotations, float offset) {
        Vec3d vec3d;
        Intrinsics.checkParameterIsNotNull((Object)point1, (String)"point1");
        Intrinsics.checkParameterIsNotNull((Object)point2, (String)"point2");
        this.point1 = point1;
        this.point2 = point2;
        this.radius1 = radius1;
        this.radius2 = radius2;
        this.rotations = rotations;
        this.offset = offset;
        Vec3d vec3d2 = this.norm = CommonUtilMethods.minus(this.point2, this.point1).func_72432_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"norm");
        if (Intrinsics.areEqual((Object)CommonUtilMethods.cross(vec3d2, new Vec3d(0.0, 1.0, 0.0)), (Object)new Vec3d(0.0, 0.0, 0.0))) {
            vec3d = new Vec3d(1.0, 0.0, 0.0);
        } else {
            Vec3d vec3d3 = this.norm;
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d3, (String)"norm");
            vec3d = CommonUtilMethods.cross(vec3d3, new Vec3d(0.0, 1.0, 0.0));
        }
        this.perpX = vec3d;
        Vec3d vec3d4 = this.norm;
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d4, (String)"norm");
        this.perpY = CommonUtilMethods.cross(vec3d4, this.perpX);
    }

    @Override
    @NotNull
    public InterpFunction<Vec3d> reverse() {
        return InterpFunction.DefaultImpls.reverse(this);
    }

    @Override
    @NotNull
    public List<Vec3d> list(int points) {
        return InterpFunction.DefaultImpls.list(this, points);
    }
}

