/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.common.LibCommonProxy;
import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import com.teamwizardry.librarianlib.features.structure.Structure$WhenMappings;
import com.teamwizardry.librarianlib.features.structure.StructureMatchResult;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0%J\u0018\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0012J\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\rH\u0007J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0004J \u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\rH\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0012@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0012@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006<"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/Structure;", "", "loc", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "<set-?>", "Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;", "blockAccess", "getBlockAccess", "()Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;", "setBlockAccess", "(Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;)V", "matchedRotation", "Lnet/minecraft/util/Rotation;", "getMatchedRotation", "()Lnet/minecraft/util/Rotation;", "setMatchedRotation", "(Lnet/minecraft/util/Rotation;)V", "Lnet/minecraft/util/math/BlockPos;", "max", "getMax", "()Lnet/minecraft/util/math/BlockPos;", "setMax", "(Lnet/minecraft/util/math/BlockPos;)V", "min", "getMin", "setMin", "origin", "getOrigin", "setOrigin", "template", "Lnet/minecraft/world/gen/structure/template/Template;", "getTemplate", "()Lnet/minecraft/world/gen/structure/template/Template;", "setTemplate", "(Lnet/minecraft/world/gen/structure/template/Template;)V", "templateBlocks", "", "Lnet/minecraft/world/gen/structure/template/Template$BlockInfo;", "getTemplateBlocks", "()Ljava/util/List;", "setTemplateBlocks", "(Ljava/util/List;)V", "blockInfos", "match", "Lcom/teamwizardry/librarianlib/features/structure/StructureMatchResult;", "world", "Lnet/minecraft/world/World;", "checkPos", "rot", "parse", "", "stream", "Ljava/io/InputStream;", "transformedBlockPos", "pos", "mirrorIn", "Lnet/minecraft/util/Mirror;", "rotationIn", "Companion", "librarianlib-1.12.2"})
public class Structure {
    @NotNull
    public Rotation matchedRotation;
    @NotNull
    protected Template template;
    @Nullable
    private List<? extends Template.BlockInfo> templateBlocks;
    @NotNull
    protected TemplateBlockAccess blockAccess;
    @NotNull
    private BlockPos origin;
    @NotNull
    private BlockPos min;
    @NotNull
    private BlockPos max;
    @NotNull
    private static final Function1<Template, Object> templateGetter;
    @JvmField
    @NotNull
    public static final List<IProperty<?>> IGNORE;
    @JvmField
    @NotNull
    public static final Multimap<IProperty<?>, List<?>> EQUIVALENTS;
    public static final Companion Companion;

    @NotNull
    public final Rotation getMatchedRotation() {
        Rotation rotation = this.matchedRotation;
        if (rotation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matchedRotation");
        }
        return rotation;
    }

    public final void setMatchedRotation(@NotNull Rotation rotation) {
        Intrinsics.checkParameterIsNotNull((Object)rotation, (String)"<set-?>");
        this.matchedRotation = rotation;
    }

    @NotNull
    protected final Template getTemplate() {
        Template template = this.template;
        if (template == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"template");
        }
        return template;
    }

    protected final void setTemplate(@NotNull Template template) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"<set-?>");
        this.template = template;
    }

    @Nullable
    protected final List<Template.BlockInfo> getTemplateBlocks() {
        return this.templateBlocks;
    }

    protected final void setTemplateBlocks(@Nullable List<? extends Template.BlockInfo> list2) {
        this.templateBlocks = list2;
    }

    @NotNull
    public final TemplateBlockAccess getBlockAccess() {
        TemplateBlockAccess templateBlockAccess = this.blockAccess;
        if (templateBlockAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockAccess");
        }
        return templateBlockAccess;
    }

    protected final void setBlockAccess(@NotNull TemplateBlockAccess templateBlockAccess) {
        Intrinsics.checkParameterIsNotNull((Object)templateBlockAccess, (String)"<set-?>");
        this.blockAccess = templateBlockAccess;
    }

    @NotNull
    public final BlockPos getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.origin = blockPos;
    }

    @NotNull
    public final BlockPos getMin() {
        return this.min;
    }

    protected final void setMin(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.min = blockPos;
    }

    @NotNull
    public final BlockPos getMax() {
        return this.max;
    }

    protected final void setMax(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.max = blockPos;
    }

    @NotNull
    public final List<Template.BlockInfo> blockInfos() {
        List list2 = this.templateBlocks;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final StructureMatchResult match(@NotNull World world, @NotNull BlockPos checkPos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)checkPos, (String)"checkPos");
        StructureMatchResult none = this.match(world, checkPos, Rotation.NONE);
        StructureMatchResult reverse = this.match(world, checkPos, Rotation.CLOCKWISE_180);
        StructureMatchResult cw = this.match(world, checkPos, Rotation.CLOCKWISE_90);
        StructureMatchResult ccw = this.match(world, checkPos, Rotation.COUNTERCLOCKWISE_90);
        StructureMatchResult finalList = none;
        this.matchedRotation = Rotation.NONE;
        if (finalList == null || reverse != null && reverse.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = reverse;
            this.matchedRotation = Rotation.CLOCKWISE_180;
        }
        if (finalList == null || cw != null && cw.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = cw;
            this.matchedRotation = Rotation.CLOCKWISE_90;
        }
        if (finalList == null || ccw != null && ccw.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = ccw;
            this.matchedRotation = Rotation.COUNTERCLOCKWISE_90;
        }
        return finalList;
    }

    @Nullable
    public final StructureMatchResult match(@NotNull World world, @NotNull BlockPos checkPos, @NotNull Rotation rot) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)checkPos, (String)"checkPos");
        Intrinsics.checkParameterIsNotNull((Object)rot, (String)"rot");
        BlockPos blockPos = checkPos.func_177973_b((Vec3i)this.origin);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"checkPos.subtract(origin)");
        StructureMatchResult result = new StructureMatchResult(blockPos, rot, this);
        List<? extends Template.BlockInfo> list2 = this.templateBlocks;
        if (list2 == null) {
            return null;
        }
        List<? extends Template.BlockInfo> infos = list2;
        for (Template.BlockInfo blockInfo : infos) {
            if (Intrinsics.areEqual((Object)blockInfo.field_186242_a, (Object)this.origin)) continue;
            BlockPos blockPos2 = blockInfo.field_186242_a.func_177973_b((Vec3i)this.origin);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"info.pos.subtract(origin)");
            BlockPos worldPos = this.transformedBlockPos(blockPos2, Mirror.NONE, rot).func_177971_a((Vec3i)checkPos);
            IBlockState worldState = world.func_180495_p(worldPos);
            IBlockState templateState = blockInfo.field_186243_b;
            boolean match = true;
            IBlockState iBlockState = worldState;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldState");
            Block block = iBlockState.func_177230_c();
            IBlockState iBlockState2 = templateState;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"templateState");
            if (block != iBlockState2.func_177230_c()) {
                if (worldState.func_177230_c() == Blocks.field_150350_a) {
                    List<BlockPos> list3 = result.getAirErrors();
                    BlockPos blockPos3 = blockInfo.field_186242_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"info.pos");
                    list3.add(blockPos3);
                } else {
                    List<BlockPos> list4 = result.getNonAirErrors();
                    BlockPos blockPos4 = blockInfo.field_186242_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"info.pos");
                    list4.add(blockPos4);
                }
                match = false;
            } else {
                Collection worldProps = worldState.func_177227_a();
                for (IProperty prop : templateState.func_177227_a()) {
                    Comparable templateValue;
                    if (IGNORE.contains(prop) || Intrinsics.areEqual((Object)templateState.func_177230_c(), (Object)Blocks.field_150488_af)) continue;
                    if (!worldProps.contains(prop)) {
                        List<BlockPos> list5 = result.getPropertyErrors();
                        BlockPos blockPos5 = blockInfo.field_186242_a;
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"info.pos");
                        list5.add(blockPos5);
                        match = false;
                        break;
                    }
                    boolean propsMatch = false;
                    IProperty iProperty = prop;
                    if (iProperty == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.minecraft.block.properties.IProperty<kotlin.Comparable<kotlin.Any>>");
                    }
                    Comparable worldValue = worldState.func_177229_b(iProperty);
                    boolean bl = propsMatch = worldValue == (templateValue = templateState.func_177229_b(prop));
                    if (!propsMatch) {
                        for (List list6 : EQUIVALENTS.get((Object)prop)) {
                            if (!list6.contains(worldValue) || !list6.contains(templateValue)) continue;
                            propsMatch = true;
                            break;
                        }
                    }
                    if (propsMatch) continue;
                    List<BlockPos> list6 = result.getPropertyErrors();
                    BlockPos blockPos6 = blockInfo.field_186242_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"info.pos");
                    list6.add(blockPos6);
                    match = false;
                    break;
                }
            }
            if (match) {
                List<BlockPos> list7 = result.getMatches();
                BlockPos blockPos7 = blockInfo.field_186242_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"info.pos");
                list7.add(blockPos7);
                continue;
            }
            List<BlockPos> list8 = result.getAllErrors();
            BlockPos blockPos8 = blockInfo.field_186242_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos8, (String)"info.pos");
            list8.add(blockPos8);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected final void parse(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Template template = this.template = new Template();
        if (template == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"template");
        }
        this.templateBlocks = Companion.getBlocks(template);
        Template template2 = this.template;
        if (template2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"template");
        }
        this.blockAccess = new TemplateBlockAccess(template2);
        try {
            int n;
            int n2;
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)stream);
            Template template3 = this.template;
            if (template3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"template");
            }
            template3.func_186256_b(tag);
            NBTTagList list2 = tag.func_150295_c("palette", 10);
            int paletteID = -1;
            int n3 = 0;
            int n4 = list2.func_74745_c() - 1;
            if (n3 <= n4) {
                while (true) {
                    void i;
                    NBTTagCompound compound;
                    if (Intrinsics.areEqual((Object)"minecraft:structure_block", (Object)(compound = list2.func_150305_b((int)i)).func_74779_i("Name"))) {
                        paletteID = i;
                        break;
                    }
                    if (i == n4) break;
                    ++i;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            if (paletteID >= 0 && (n2 = 0) <= (n = (list2 = tag.func_150295_c("blocks", 10)).func_74745_c() - 1)) {
                while (true) {
                    void i;
                    NBTTagCompound compound = list2.func_150305_b((int)i);
                    NBTTagList posList = compound.func_150295_c("pos", 3);
                    BlockPos pos2 = new BlockPos(posList.func_186858_c(0), posList.func_186858_c(1), posList.func_186858_c(2));
                    if (compound.func_74762_e("state") == paletteID) {
                        this.origin = pos2;
                    }
                    minX = Math.min(minX, pos2.func_177958_n());
                    minY = Math.min(minY, pos2.func_177956_o());
                    minZ = Math.min(minZ, pos2.func_177952_p());
                    maxX = Math.max(maxX, pos2.func_177958_n());
                    maxY = Math.max(maxY, pos2.func_177956_o());
                    maxZ = Math.max(maxZ, pos2.func_177952_p());
                    if (i == n) break;
                    ++i;
                }
            }
            this.min = new BlockPos(minX, minY, minZ);
            this.max = new BlockPos(maxX, maxY, maxZ);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final BlockPos transformedBlockPos(BlockPos pos2, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos2.func_177958_n();
        int j = pos2.func_177956_o();
        int k = pos2.func_177952_p();
        boolean flag = true;
        switch (Structure$WhenMappings.$EnumSwitchMapping$0[mirrorIn.ordinal()]) {
            case 1: {
                k = -k;
                break;
            }
            case 2: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (Structure$WhenMappings.$EnumSwitchMapping$1[rotationIn.ordinal()]) {
            case 1: {
                return new BlockPos(k, j, -i);
            }
            case 2: {
                return new BlockPos(-k, j, i);
            }
            case 3: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos2;
    }

    public Structure(@NotNull ResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        BlockPos blockPos = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.ORIGIN");
        this.origin = blockPos;
        BlockPos blockPos2 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN");
        this.min = blockPos2;
        BlockPos blockPos3 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"BlockPos.ORIGIN");
        this.max = blockPos3;
        LibCommonProxy libCommonProxy = LibrarianLib.INSTANCE.getPROXY();
        String string = loc.func_110624_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loc.namespace");
        InputStream stream = libCommonProxy.getResource(string, "schematics/" + loc.func_110623_a() + ".nbt");
        if (stream != null) {
            try {
                this.parse(stream);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Companion = new Companion(null);
        templateGetter = MethodHandleHelper.wrapperForGetter(Template.class, "blocks", "field_186270_a");
        IGNORE = new ArrayList(Arrays.asList((PropertyHelper)BlockSlab.field_176554_a, (PropertyHelper)BlockStairs.field_176310_M, (PropertyHelper)BlockStairs.field_176309_a, (PropertyHelper)BlockPane.field_176242_M, (PropertyHelper)BlockPane.field_176244_O, (PropertyHelper)BlockPane.field_176241_b, (PropertyHelper)BlockPane.field_176243_N, (PropertyHelper)BlockRedstoneComparator.field_185512_D, (PropertyHelper)BlockRedstoneComparator.field_176463_b, (PropertyHelper)BlockRedstoneComparator.field_176464_a, (PropertyHelper)BlockRedstoneRepeater.field_185512_D, (PropertyHelper)BlockRedstoneRepeater.field_176410_b, (PropertyHelper)BlockRedstoneRepeater.field_176411_a));
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"HashMultimap.create<IProperty<*>, List<*>>()");
        EQUIVALENTS = (Multimap)hashMultimap;
        EQUIVALENTS.put((Object)BlockQuartz.field_176335_a, Arrays.asList(BlockQuartz.EnumType.LINES_X, BlockQuartz.EnumType.LINES_Y, BlockQuartz.EnumType.LINES_Z));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006*\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/Structure$Companion;", "", "()V", "EQUIVALENTS", "Lcom/google/common/collect/Multimap;", "Lnet/minecraft/block/properties/IProperty;", "", "IGNORE", "", "templateGetter", "Lkotlin/Function1;", "Lnet/minecraft/world/gen/structure/template/Template;", "getTemplateGetter", "()Lkotlin/jvm/functions/Function1;", "blocks", "Lnet/minecraft/world/gen/structure/template/Template$BlockInfo;", "blocks$annotations", "(Lnet/minecraft/world/gen/structure/template/Template;)V", "getBlocks", "(Lnet/minecraft/world/gen/structure/template/Template;)Ljava/util/List;", "librarianlib-1.12.2"})
    public static final class Companion {
        @NotNull
        public final Function1<Template, Object> getTemplateGetter() {
            return templateGetter;
        }

        public static /* synthetic */ void blocks$annotations(Template template) {
        }

        @NotNull
        public final List<Template.BlockInfo> getBlocks(@NotNull Template $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Object object = Companion.getTemplateGetter().invoke((Object)$receiver);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<net.minecraft.world.gen.structure.template.Template.BlockInfo>");
            }
            return (List)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

