/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.rwtema.extrautils2.XU2Entries112;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompatHelper112 {
    static HashSet<ResourceLocation> registeredRecipes = new HashSet();

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(ItemStack itemStack, EntityPlayer player, boolean advancedItemTooltips) {
        return itemStack.func_82840_a(player, (ITooltipFlag)(advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    public static Collection<? extends String> getTooltip(ItemStack itemStack, ItemTooltipEvent event) {
        return itemStack.func_82840_a(event.getEntityPlayer(), event.getFlags());
    }

    public static List<String> getTooltip(ItemTooltipEvent event) {
        return event.getItemStack().func_82840_a(event.getEntityPlayer(), event.getFlags());
    }

    public static <T extends XUBlock> boolean isChunkProviderEnd(Object provider) {
        return provider instanceof ChunkGeneratorEnd;
    }

    public static <T extends IForgeRegistryEntry<T>> void register(T value) {
        GameRegistry.findRegistry((Class)value.getRegistryType()).register(value);
    }

    public static <T> Optional<T> optionalOf(T value) {
        return Optional.of(value);
    }

    public static VillagerRegistry.VillagerProfession getVillagerProfession(String name1, String texture1) {
        return new VillagerRegistry.VillagerProfession("extrautils2:" + name1, "extrautils2:textures/villagers/" + texture1 + ".png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
    }

    public static void addRecipe(IRecipe recipe) {
        if (!registeredRecipes.add(recipe.getRegistryName())) {
            throw new IllegalArgumentException(recipe.getRegistryName() + " was added twice");
        }
        CompatHelper112.register(recipe);
    }

    public static void damage(ItemStack itemStackIn, int amount, Random rand) {
        itemStackIn.func_96631_a(amount, rand, null);
    }

    public static void drainExperience(EntityPlayer player, int amount, ItemStack recipeOutput) {
        player.func_192024_a(recipeOutput, amount);
    }

    public static void loadVersionSpecificEntries() {
        XU2Entries112.init();
    }

    public static EntityLiving getMobForSpawning(WorldServer world, Biome.SpawnListEntry entry2) {
        EntityLiving mob;
        EntityEntry entityEntry = EntityRegistry.getEntry((Class)entry2.field_76300_b);
        if (entityEntry == null || BlockCursedEarth.entity_blacklist.contains(Objects.toString(entityEntry.getRegistryName()))) {
            mob = null;
        } else {
            try {
                mob = (EntityLiving)entityEntry.newInstance((World)world);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                mob = null;
            }
        }
        return mob;
    }
}

