/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.BoxType;
import mod.chiselsandbits.api.EventBlockBitPostModification;
import mod.chiselsandbits.api.EventFullBlockRestoration;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IChiseledBlockTileEntity;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IChiseledTileContainer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBlockChiseled
extends TileEntity
implements IChiseledTileContainer,
IChiseledBlockTileEntity {
    private IExtendedBlockState state;
    public IChiseledTileContainer occlusionState;
    boolean isNormalCube = false;
    int sideState = 0;
    int lightlevel = -1;
    private static ThreadLocal<Integer> localLightLevel = new ThreadLocal();
    private ItemStackGeneratedCache pickcache = null;

    public IChiseledTileContainer getTileContainer() {
        if (this.occlusionState != null) {
            return this.occlusionState;
        }
        return this;
    }

    @Override
    public boolean isBlobOccluded(VoxelBlob blob) {
        return false;
    }

    @Override
    public void saveData() {
        super.func_70296_d();
    }

    @Override
    public void sendUpdate() {
        ModUtil.sendUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void copyFrom(TileEntityBlockChiseled src) {
        this.state = src.state;
        this.isNormalCube = src.isNormalCube;
        this.sideState = src.sideState;
        this.lightlevel = src.lightlevel;
    }

    public IExtendedBlockState getBasicState() {
        return this.getState(false, 0, (IBlockAccess)this.field_145850_b);
    }

    public IExtendedBlockState getRenderState(IBlockAccess access) {
        return this.getState(true, 1, access);
    }

    protected boolean supportsSwapping() {
        return true;
    }

    @Nonnull
    protected IExtendedBlockState getState(boolean updateNeightbors, int updateCost, IBlockAccess access) {
        if (this.state == null) {
            return (IExtendedBlockState)ChiselsAndBits.getBlocks().getChiseledDefaultState();
        }
        if (updateNeightbors) {
            boolean isDyanmic = this instanceof TileEntityBlockChiseledTESR;
            final VoxelNeighborRenderTracker vns = (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (vns == null) {
                return this.state;
            }
            vns.update(isDyanmic, access, this.field_174879_c);
            this.tesrUpdate(access, vns);
            final TileEntityBlockChiseled self = this;
            if (this.supportsSwapping() && vns.isAboveLimit() && !isDyanmic) {
                ChisledBlockRenderChunkTESR.addNextFrameTask(new Runnable(){

                    @Override
                    public void run() {
                        if (self.field_145850_b != null && self.field_174879_c != null) {
                            TileEntity current = self.field_145850_b.func_175625_s(self.field_174879_c);
                            TileEntityBlockChiseled dat = MCMultipartProxy.proxyMCMultiPart.getChiseledTileEntity(self.field_145850_b, self.field_174879_c, false);
                            if (current == null || self.func_145837_r()) {
                                return;
                            }
                            if (current == self) {
                                current.func_145843_s();
                                TileEntityBlockChiseledTESR TESR = new TileEntityBlockChiseledTESR();
                                TESR.copyFrom(self);
                                self.field_145850_b.func_175713_t(self.field_174879_c);
                                self.field_145850_b.func_175690_a(self.field_174879_c, (TileEntity)TESR);
                                self.field_145850_b.func_175704_b(self.field_174879_c, self.field_174879_c);
                                vns.unlockDynamic();
                            } else if (dat == self) {
                                MCMultipartProxy.proxyMCMultiPart.convertTo(current, new TileEntityBlockChiseledTESR());
                                vns.unlockDynamic();
                            }
                        }
                    }
                });
            } else if (this.supportsSwapping() && !vns.isAboveLimit() && isDyanmic) {
                ChisledBlockRenderChunkTESR.addNextFrameTask(new Runnable(){

                    @Override
                    public void run() {
                        if (self.field_145850_b != null && self.field_174879_c != null) {
                            TileEntity current = self.field_145850_b.func_175625_s(self.field_174879_c);
                            TileEntityBlockChiseled dat = MCMultipartProxy.proxyMCMultiPart.getChiseledTileEntity(self.field_145850_b, self.field_174879_c, false);
                            if (current == null || self.func_145837_r()) {
                                return;
                            }
                            if (current == self) {
                                current.func_145843_s();
                                TileEntityBlockChiseled nonTesr = new TileEntityBlockChiseled();
                                nonTesr.copyFrom(self);
                                self.field_145850_b.func_175713_t(self.field_174879_c);
                                self.field_145850_b.func_175690_a(self.field_174879_c, (TileEntity)nonTesr);
                                self.field_145850_b.func_175704_b(self.field_174879_c, self.field_174879_c);
                                vns.unlockDynamic();
                            } else if (dat == self) {
                                MCMultipartProxy.proxyMCMultiPart.convertTo(current, new TileEntityBlockChiseled());
                                vns.unlockDynamic();
                            }
                        }
                    }
                });
            }
        }
        return this.state;
    }

    protected void tesrUpdate(IBlockAccess access, VoxelNeighborRenderTracker vns) {
    }

    public BlockBitInfo getBlockInfo(Block alternative) {
        return BlockBitInfo.getBlockInfo(this.getBlockState(alternative));
    }

    public IBlockState getBlockState(Block alternative) {
        IBlockState state;
        Integer stateID = (Integer)this.getBasicState().getValue(BlockChiseled.UProperty_Primary_BlockState);
        if (stateID != null && (state = ModUtil.getStateById(stateID)) != null) {
            return state;
        }
        return alternative.func_176223_P();
    }

    public void setState(IExtendedBlockState state) {
        VoxelBlobStateReference originalRef = (VoxelBlobStateReference)this.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob);
        VoxelBlobStateReference newRef = (VoxelBlobStateReference)state.getValue(BlockChiseled.UProperty_VoxelBlob);
        this.state = state;
        if (originalRef != null && newRef != null && !newRef.equals(originalRef)) {
            EventBlockBitPostModification bmm = new EventBlockBitPostModification(this.func_145831_w(), this.func_174877_v());
            MinecraftForge.EVENT_BUS.post((Event)bmm);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeChisleData(nbttagcompound);
        if (nbttagcompound.func_82582_d()) {
            return null;
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 255, nbttagcompound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("x", this.field_174879_c.func_177958_n());
        nbttagcompound.func_74768_a("y", this.field_174879_c.func_177956_o());
        nbttagcompound.func_74768_a("z", this.field_174879_c.func_177952_p());
        this.writeChisleData(nbttagcompound);
        return nbttagcompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readChisleData(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        int oldLight = this.lightlevel;
        boolean changed = this.readChisleData(pkt.func_148857_g());
        if (this.field_145850_b != null && changed) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.triggerDynamicUpdates();
            if (oldLight != this.lightlevel) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
        }
    }

    private void triggerDynamicUpdates() {
        if (this.field_145850_b.field_72995_K && this.state != null) {
            VoxelNeighborRenderTracker vns = (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (vns != null && vns.isDynamic()) {
                return;
            }
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntityBlockChiseledTESR tesr;
                TileEntity te;
                BlockPos p = this.func_174877_v().func_177972_a(f);
                if (!this.field_145850_b.func_175667_e(p) || !((te = this.field_145850_b.func_175625_s(p)) instanceof TileEntityBlockChiseledTESR) || (tesr = (TileEntityBlockChiseledTESR)te).getRenderChunk() == null) continue;
                tesr.getRenderChunk().rebuild(false);
            }
        }
    }

    public boolean readChisleData(NBTTagCompound tag) {
        NBTBlobConverter converter = new NBTBlobConverter(false, this);
        boolean changed = converter.readChisleData(tag, 0);
        VoxelNeighborRenderTracker vns = (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (vns != null) {
            vns.triggerUpdate();
        }
        return changed;
    }

    public void writeChisleData(NBTTagCompound tag) {
        new NBTBlobConverter(false, this).writeChisleData(tag, false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeChisleData(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readChisleData(compound);
    }

    @Override
    public NBTTagCompound writeTileEntityToTag(NBTTagCompound tag, boolean crossWorld) {
        super.func_189515_b(tag);
        new NBTBlobConverter(false, this).writeChisleData(tag, crossWorld);
        tag.func_74757_a("cw", crossWorld);
        return tag;
    }

    public void func_189668_a(Mirror p_189668_1_) {
        switch (p_189668_1_) {
            case FRONT_BACK: {
                this.setBlob(this.getBlob().mirror(EnumFacing.Axis.X), true);
                break;
            }
            case LEFT_RIGHT: {
                this.setBlob(this.getBlob().mirror(EnumFacing.Axis.Z), true);
                break;
            }
        }
    }

    public void func_189667_a(Rotation p_189667_1_) {
        switch (p_189667_1_) {
            case CLOCKWISE_90: {
                this.setBlob(this.getBlob().spin(EnumFacing.Axis.Y).spin(EnumFacing.Axis.Y).spin(EnumFacing.Axis.Y), true);
                break;
            }
            case CLOCKWISE_180: {
                this.setBlob(this.getBlob().spin(EnumFacing.Axis.Y).spin(EnumFacing.Axis.Y), true);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.setBlob(this.getBlob().spin(EnumFacing.Axis.Y), true);
                break;
            }
        }
    }

    public void fillWith(IBlockState blockType) {
        int ref = ModUtil.getStateId(blockType);
        this.sideState = 255;
        this.lightlevel = DeprecationHelper.getLightValue(blockType);
        this.isNormalCube = ModUtil.isNormalCube(blockType);
        IExtendedBlockState state = this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(ModUtil.getStateId(blockType), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
        VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (tracker == null) {
            state = state.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
        } else {
            tracker.isDynamic();
        }
        if (ref != 0) {
            state = state.withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)ref);
        }
        this.setState(state);
        this.getTileContainer().saveData();
    }

    public static long getPositionRandom(BlockPos pos) {
        if (pos != null && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return MathHelper.func_180186_a((Vec3i)pos);
        }
        return 0L;
    }

    public VoxelBlobStateReference getBlobStateReference() {
        return (VoxelBlobStateReference)this.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob);
    }

    public VoxelBlob getBlob() {
        VoxelBlob vb = null;
        VoxelBlobStateReference vbs = this.getBlobStateReference();
        if (vbs != null) {
            vb = vbs.getVoxelBlob();
            if (vb == null) {
                vb = new VoxelBlob();
                vb.fill(ModUtil.getStateId(Blocks.field_150347_e.func_176223_P()));
            }
        } else {
            vb = new VoxelBlob();
        }
        return vb;
    }

    public IBlockState getPreferedBlock() {
        return ChiselsAndBits.getBlocks().getConversionWithDefault(this.getBlockState(Blocks.field_150348_b)).func_176223_P();
    }

    public void setBlob(VoxelBlob vb) {
        this.setBlob(vb, true);
    }

    public boolean updateBlob(NBTBlobConverter converter, boolean triggerUpdates) {
        int oldLV = this.getLightValue();
        boolean oldNC = this.isNormalCube();
        int oldSides = this.sideState;
        VoxelBlobStateReference originalRef = (VoxelBlobStateReference)this.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob);
        VoxelBlobStateReference voxelRef = null;
        this.sideState = converter.getSideState();
        int b = converter.getPrimaryBlockStateID();
        this.lightlevel = converter.getLightValue();
        this.isNormalCube = converter.isNormalCube();
        try {
            voxelRef = converter.getVoxelRef(0, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c));
        }
        catch (Exception e) {
            if (this.func_174877_v() != null) {
                Log.logError("Unable to read blob at " + this.func_174877_v(), e);
            } else {
                Log.logError("Unable to read blob.", e);
            }
            voxelRef = new VoxelBlobStateReference(0, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c));
        }
        IExtendedBlockState newstate = this.getBasicState().withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)b).withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)voxelRef);
        VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)newstate.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (tracker == null) {
            newstate = newstate.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
        } else {
            tracker.isDynamic();
        }
        this.setState(newstate);
        if (this.func_145830_o() && triggerUpdates) {
            if (oldLV != this.getLightValue() || oldNC != this.isNormalCube()) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (state.func_185917_h() != this.isNormalCube && state.func_177230_c() instanceof BlockChiseled) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockChiseled.LProperty_FullBlock, (Comparable)Boolean.valueOf(this.isNormalCube)));
                }
            }
            if (oldSides != this.sideState) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
            }
        }
        return voxelRef != null ? !voxelRef.equals(originalRef) : true;
    }

    public void setBlob(VoxelBlob vb, boolean triggerUpdates) {
        Integer olv = this.getLightValue();
        Boolean oldNC = this.isNormalCube();
        VoxelBlob.BlobStats common = vb.getVoxelStats();
        float light = common.blockLight;
        boolean nc = common.isNormalBlock;
        int lv = Math.max(0, Math.min(15, (int)(light * 15.0f)));
        int sideFlags = vb.getSideFlags(5, 11, 16);
        if (!this.func_145830_o()) {
            if (common.mostCommonState == 0) {
                Integer i = (Integer)this.getBasicState().getValue(BlockChiseled.UProperty_Primary_BlockState);
                common.mostCommonState = i != null ? i : ModUtil.getStateId(Blocks.field_150348_b.func_176223_P());
            }
            this.sideState = sideFlags;
            this.lightlevel = lv;
            this.isNormalCube = nc;
            IExtendedBlockState newState = this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(vb.blobToBytes(0), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker()).withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)common.mostCommonState);
            VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)newState.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (tracker == null) {
                newState = newState.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
            } else {
                tracker.isDynamic();
            }
            this.setState(newState);
            return;
        }
        if (common.isFullBlock) {
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(common.mostCommonState, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c))));
            IBlockState newState = ModUtil.getStateById(common.mostCommonState);
            if (ChiselsAndBits.getConfig().canRevertToBlock(newState) && !MinecraftForge.EVENT_BUS.post((Event)new EventFullBlockRestoration(this.field_145850_b, this.field_174879_c, newState))) {
                this.field_145850_b.func_180501_a(this.field_174879_c, newState, triggerUpdates ? 3 : 0);
            }
        } else if (common.mostCommonState != 0) {
            this.sideState = sideFlags;
            this.lightlevel = lv;
            this.isNormalCube = nc;
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(vb.blobToBytes(0), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)common.mostCommonState));
            this.getTileContainer().saveData();
            this.getTileContainer().sendUpdate();
            Block blk = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            MCMultipartProxy.proxyMCMultiPart.triggerPartChange(this.field_145850_b.func_175625_s(this.field_174879_c));
            if (triggerUpdates) {
                this.field_145850_b.func_175685_c(this.field_174879_c, blk, false);
            }
        } else {
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(0, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c))));
            ModUtil.removeChisledBlock(this.field_145850_b, this.field_174879_c);
        }
        if (olv != lv || oldNC != nc) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_185917_h() != this.isNormalCube && state.func_177230_c() instanceof BlockChiseled) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockChiseled.LProperty_FullBlock, (Comparable)Boolean.valueOf(this.isNormalCube)));
            }
        }
    }

    public ItemStack getItemStack(EntityPlayer player) {
        ItemStackGeneratedCache cache = this.pickcache;
        if (player != null) {
            EnumFacing enumfacing = ModUtil.getPlaceFace((EntityLivingBase)player);
            int rotations = ModUtil.getRotationIndex(enumfacing);
            if (cache != null && cache.rotations == rotations && cache.ref == this.getBlobStateReference() && cache.out != null) {
                return cache.getItemStack();
            }
            VoxelBlob vb = this.getBlob();
            int countDown = rotations;
            while (countDown > 0) {
                --countDown;
                enumfacing = enumfacing.func_176735_f();
                vb = vb.spin(EnumFacing.Axis.Y);
            }
            BitAccess ba = new BitAccess(null, null, vb, VoxelBlob.NULL_BLOB);
            ItemStack itemstack = ba.getBitsAsItem(enumfacing, ItemType.CHISLED_BLOCK, false);
            this.pickcache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), rotations);
            return itemstack;
        }
        if (cache != null && cache.rotations == 0 && cache.ref == this.getBlobStateReference()) {
            return cache.getItemStack();
        }
        BitAccess ba = new BitAccess(null, null, this.getBlob(), VoxelBlob.NULL_BLOB);
        ItemStack itemstack = ba.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
        this.pickcache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), 0);
        return itemstack;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    public boolean isSideSolid(EnumFacing side) {
        return (this.sideState & 1 << side.ordinal()) != 0;
    }

    public boolean isSideOpaque(EnumFacing side) {
        if (this.func_145831_w().field_72995_K) {
            return this.isInnerSideOpaque(side);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInnerSideOpaque(EnumFacing side) {
        VoxelNeighborRenderTracker vns;
        VoxelNeighborRenderTracker voxelNeighborRenderTracker = vns = this.state != null ? (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState) : null;
        if (vns != null && vns.isDynamic()) {
            return false;
        }
        Integer sideFlags = ChiseledBlockSmartModel.getSides(this);
        return (sideFlags & 1 << side.ordinal()) != 0;
    }

    public void completeEditOperation(VoxelBlob vb) {
        VoxelBlobStateReference before = this.getBlobStateReference();
        this.setBlob(vb);
        VoxelBlobStateReference after = this.getBlobStateReference();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.triggerDynamicUpdates();
        }
        UndoTracker.getInstance().add(this.func_145831_w(), this.func_174877_v(), before, after);
    }

    public void rotateBlock(EnumFacing axis) {
        VoxelBlob occluded = new VoxelBlob();
        MCMultipartProxy.proxyMCMultiPart.addFiller(this.func_145831_w(), this.func_174877_v(), occluded);
        VoxelBlob postRotation = this.getBlob();
        int maxRotations = 4;
        while (--maxRotations > 0) {
            if (!occluded.canMerge(postRotation = postRotation.spin(axis.func_176740_k()))) continue;
            this.setBlob(postRotation);
            return;
        }
    }

    public boolean canMerge(VoxelBlob voxelBlob) {
        VoxelBlob vb = this.getBlob();
        IChiseledTileContainer occ = this.getTileContainer();
        return vb.canMerge(voxelBlob) && !occ.isBlobOccluded(voxelBlob);
    }

    @Override
    public Collection<AxisAlignedBB> getBoxes(BoxType type) {
        VoxelBlobStateReference ref = this.getBlobStateReference();
        if (ref != null) {
            return ref.getBoxes(type);
        }
        return Collections.emptyList();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 1));
    }

    public void setNormalCube(boolean b) {
        this.isNormalCube = b;
    }

    public static void setLightFromBlock(IBlockState defaultState) {
        if (defaultState == null) {
            localLightLevel.remove();
        } else {
            localLightLevel.set(DeprecationHelper.getLightValue(defaultState));
        }
    }

    public int getLightValue() {
        if (this.lightlevel < 0) {
            Integer tmp = localLightLevel.get();
            this.lightlevel = tmp == null ? 0 : tmp;
        }
        return this.lightlevel;
    }

    public void func_145843_s() {
        if (this.field_145850_b != null) {
            this.triggerDynamicUpdates();
        }
    }

    public void finishUpdate() {
    }

    @Override
    public IBitAccess getBitAccess() {
        VoxelBlob mask = VoxelBlob.NULL_BLOB;
        if (this.field_145850_b != null) {
            mask = new VoxelBlob();
            MCMultipartProxy.proxyMCMultiPart.addFiller(this.func_145831_w(), this.func_174877_v(), mask);
        }
        return new BitAccess(this.field_145850_b, this.field_174879_c, this.getBlob(), mask);
    }

    private static class ItemStackGeneratedCache {
        final ItemStack out;
        final VoxelBlobStateReference ref;
        final int rotations;

        public ItemStackGeneratedCache(ItemStack itemstack, VoxelBlobStateReference blobStateReference, int rotations2) {
            this.out = itemstack == null ? null : itemstack.func_77946_l();
            this.ref = blobStateReference;
            this.rotations = rotations2;
        }

        public ItemStack getItemStack() {
            return this.out == null ? null : this.out.func_77946_l();
        }
    }

    public static class TileEntityBlockChiseledDummy
    extends TileEntityBlockChiseled {
    }
}

