/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.util;

import com.google.common.collect.Lists;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Timer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.util.ClientUtil;
import team.chisel.common.util.NonnullType;
import team.chisel.ctm.client.util.RegionCache;

@ParametersAreNonnullByDefault
public class ChiselModeGeometryCache
implements IWorldEventListener {
    private IChiselMode mode;
    private BlockPos origin;
    private EnumFacing side;
    private long[] cacheState = new long[0];
    private List<BlockPos> candidateCache = new ArrayList<BlockPos>();
    private AxisAlignedBB candidateBounds = new AxisAlignedBB(BlockPos.field_177992_a);
    private TDoubleList geometryCache = new TDoubleArrayList();

    public ChiselModeGeometryCache(IChiselMode mode, BlockPos origin, EnumFacing side) {
        this.mode = mode;
        this.origin = origin;
        this.side = side;
        this.updateCache();
    }

    public void setMode(IChiselMode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.updateCache();
        }
    }

    public void setOrigin(BlockPos origin) {
        if (!this.origin.equals((Object)origin)) {
            this.origin = origin;
            if (this.checkDirty()) {
                this.updateCache();
            }
        }
    }

    public void setSide(EnumFacing side) {
        if (this.side != side) {
            this.side = side;
            if (this.checkDirty()) {
                this.updateCache();
            }
        }
    }

    public int size() {
        return this.candidateCache.size();
    }

    protected boolean checkDirty() {
        return !Arrays.equals(this.cacheState, this.mode.getCacheState(this.origin, this.side));
    }

    protected void updateCache() {
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(this.origin);
        ICarvingGroup group = CarvingUtils.getChiselRegistry().getGroup(state);
        if (group != null) {
            this.candidateCache = Lists.newArrayList(this.mode.getCandidates((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.origin, this.side));
            this.candidateBounds = this.mode.getBounds(this.side).func_186670_a(this.origin);
            this.cacheState = this.mode.getCacheState(this.origin, this.side);
        } else {
            this.candidateCache.clear();
            this.candidateBounds = Block.field_185505_j.func_186670_a(this.origin);
            this.cacheState = new long[0];
        }
        this.draw(state);
    }

    private void draw(IBlockState state) {
        this.geometryCache.clear();
        RegionCache world = new RegionCache(this.origin, 20, (IBlockAccess)Minecraft.func_71410_x().field_71441_e);
        for (BlockPos blockPos : this.getCandidates()) {
            AxisAlignedBB bb = state.func_185918_c((World)Minecraft.func_71410_x().field_71441_e, blockPos);
            this.drawCulledBox(bb, (IBlockAccess)world, blockPos);
        }
    }

    private void drawCulledBox(AxisAlignedBB bb, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185894_c(world, pos, EnumFacing.DOWN)) {
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        }
        if (state.func_185894_c(world, pos, EnumFacing.UP)) {
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        }
        if (state.func_185894_c(world, pos, EnumFacing.NORTH)) {
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        }
        if (state.func_185894_c(world, pos, EnumFacing.SOUTH)) {
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        }
        if (state.func_185894_c(world, pos, EnumFacing.WEST)) {
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
            this.pos(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
            this.pos(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        }
        if (state.func_185894_c(world, pos, EnumFacing.EAST)) {
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
            this.pos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
            this.pos(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        }
    }

    private void pos(double x, double y, double z) {
        this.geometryCache.add(x);
        this.geometryCache.add(y);
        this.geometryCache.add(z);
    }

    public Iterable<@NonnullType ? extends BlockPos> getCandidates() {
        return this.candidateCache;
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        this.checkRedraw(new AxisAlignedBB(pos));
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.checkRedraw(new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    private void checkRedraw(AxisAlignedBB updateRange) {
        if (updateRange.func_72326_a(this.candidateBounds)) {
            Minecraft.func_71410_x().func_152344_a(this::updateCache);
        }
    }

    public void draw() {
        if (this.checkDirty()) {
            this.updateCache();
        }
        Timer timer = ClientUtil.getTimer();
        float c = 1.0f;
        float a = 0.2f;
        if (timer != null) {
            c = Math.round((float)Math.sin(((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + timer.field_194147_b) / 5.0f) / 2.0f + 0.5f);
            a = Math.abs(2.0f * (float)Math.sin(((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + timer.field_194147_b) / 5.0f)) * 0.1f;
        }
        GlStateManager.func_179094_E();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < this.geometryCache.size(); i += 3) {
            buf.func_181662_b(this.geometryCache.get(i), this.geometryCache.get(i + 1), this.geometryCache.get(i + 2)).func_181666_a(c, c, c, a).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }
}

