/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld;

import cofh.cofhworld.command.CommandCoFHWorld;
import cofh.cofhworld.init.WorldHandler;
import cofh.cofhworld.init.WorldProps;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cofhworld", name="CoFH World", version="1.2.0", dependencies="required-after:forge@[14.23.3.2655,15.0.0.0);", updateJSON="https://raw.github.com/cofh/version/master/cofhworld_update.json", certificateFingerprint="8a6abf2cb9e141b866580d369ba6548732eff25f", acceptedMinecraftVersions="[1.12.2]")
public class CoFHWorld {
    public static final String MOD_ID = "cofhworld";
    public static final String MOD_NAME = "CoFH World";
    public static final String VERSION = "1.2.0";
    public static final String VERSION_MAX = "2.0.0";
    public static final String VERSION_GROUP = "required-after:cofhworld@[1.2.0,2.0.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/cofhworld_update.json";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.3.2655,15.0.0.0);";
    @Mod.Instance(value="cofhworld")
    public static CoFHWorld instance;
    public static Logger log;
    public static Configuration config;

    public CoFHWorld() {
        WorldHandler.register();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        WorldProps.configDir = event.getModConfigurationDirectory();
        config = new Configuration(new File(WorldProps.configDir, "/cofh/world/config.cfg"), VERSION, true);
        config.load();
        WorldProps.preInit();
        WorldHandler.initialize();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        WorldHandler.reloadConfig();
        config.save();
        log.info("CoFH World: Load Complete.");
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCoFHWorld());
    }

    static {
        log = LogManager.getLogger((String)MOD_ID);
    }
}

