/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.exceptions.InvalidGeneratorException;
import cofh.cofhworld.world.generator.WorldGenMinablePlate;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class PlateParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) throws InvalidGeneratorException {
        int clusterSize = genObject.getInt("radius");
        if (clusterSize <= 0) {
            log.warn("Invalid `radius` for generator '{}'", (Object)name);
            throw new InvalidGeneratorException("Invalid `radius`", genObject.getValue("radius").origin());
        }
        WorldGenMinablePlate r = new WorldGenMinablePlate(resList, MathHelper.func_76125_a((int)clusterSize, (int)0, (int)32), matList);
        if (genObject.hasPath("height")) {
            r.setHeight(FeatureParser.parseNumberValue(genObject.root().get("height"), 0, 64));
        }
        if (genObject.hasPath("slim")) {
            r.setSlim(genObject.getBoolean("slim"));
        }
        return r;
    }
}

