/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.generator;

import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.Fluid;

public class FeatureGenUnderfluid
extends FeatureBase {
    final boolean water;
    final WorldGenerator worldGen;
    final INumberProvider count;
    final List<WeightedRandomBlock> matList;
    final String[] fluidList;

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, int count, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        this(name, worldGen, matList, new ConstantProvider(count), biomeRes, regen, dimRes);
    }

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, String[] fluidList, int count, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        this(name, worldGen, matList, fluidList, new ConstantProvider(count), biomeRes, regen, dimRes);
    }

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, INumberProvider count, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = true;
        this.fluidList = null;
    }

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, String[] fluidList, INumberProvider count, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = false;
        this.fluidList = fluidList;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int y = Utils.getSurfaceBlockY(world, x, z);
            block1: do {
                Fluid fluid;
                IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                if (this.water ? state.func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a() != Material.field_151586_h : (fluid = Utils.lookupFluidForBlock(state.func_177230_c())) != null && Arrays.binarySearch(this.fluidList, fluid.getName()) >= 0 || (fluid = Utils.lookupFluidForBlock(world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c())) == null || Arrays.binarySearch(this.fluidList, fluid.getName()) < 0) continue;
                for (WeightedRandomBlock mat : this.matList) {
                    if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, new BlockPos(x, y, z), (Predicate)BlockMatcher.func_177642_a((Block)mat.block))) continue;
                    break block1;
                }
            } while (y-- > 1);
            if (y <= 0) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

