/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.util;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public final class WeightedRandomBlock
extends WeightedRandom.Item {
    public final Block block;
    public final int metadata;
    public final IBlockState state;

    public WeightedRandomBlock(ItemStack ore) {
        this(ore, 100);
    }

    public WeightedRandomBlock(ItemStack ore, int weight) {
        this(Block.func_149634_a((Item)ore.func_77973_b()), ore.func_77952_i(), weight);
    }

    public WeightedRandomBlock(Block ore) {
        this(ore, 0, 100);
    }

    public WeightedRandomBlock(Block ore, int metadata) {
        this(ore, metadata, 100);
    }

    public WeightedRandomBlock(Block ore, int metadata, int weight) {
        super(weight);
        this.block = ore;
        this.metadata = metadata;
        this.state = null;
    }

    public WeightedRandomBlock(IBlockState ore, int weight) {
        super(weight);
        this.block = ore.func_177230_c();
        this.metadata = this.block.func_176201_c(ore);
        this.state = ore;
    }

    public static boolean isBlockContained(Block block, int metadata, Collection<WeightedRandomBlock> list) {
        for (WeightedRandomBlock rb : list) {
            if (!block.equals(rb.block) || metadata != -1 && rb.metadata != -1 && rb.metadata != metadata) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockContained(Block block, int metadata, WeightedRandomBlock[] list) {
        for (WeightedRandomBlock rb : list) {
            if (!block.equals(rb.block) || metadata != -1 && rb.metadata != -1 && rb.metadata != metadata) continue;
            return true;
        }
        return false;
    }

    public IBlockState getState() {
        return this.state == null ? this.block.func_176203_a(this.metadata) : this.state;
    }
}

