/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBoulder
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final int size;
    public int sizeVariance = 2;
    public int clusters = 3;
    public int clusterVariance = 0;
    public boolean hollow = false;
    public float hollowAmt = 0.1665f;
    public float hollowVar = 0.0f;

    public WorldGenBoulder(List<WeightedRandomBlock> resource, int minSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.size = minSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i;
        int xCenter = pos.func_177958_n();
        int yCenter = pos.func_177956_o();
        int zCenter = pos.func_177952_p();
        int minSize = this.size;
        int var = this.sizeVariance;
        boolean r = false;
        int n = i = this.clusterVariance > 0 ? this.clusters + rand.nextInt(this.clusterVariance + 1) : this.clusters;
        while (i-- > 0) {
            while (yCenter > minSize && world.func_175623_d(new BlockPos(xCenter, yCenter - 1, zCenter))) {
                --yCenter;
            }
            if (yCenter <= minSize + var + 1) {
                return false;
            }
            if (WorldGenMinableCluster.canGenerateInBlock(world, xCenter, yCenter - 1, zCenter, this.genBlock)) {
                int xWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                int yWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                int zWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                float maxDist = (float)(xWidth + yWidth + zWidth) * 0.333f + 0.5f;
                maxDist *= maxDist;
                float minDist = this.hollow ? (float)(xWidth + yWidth + zWidth) * (this.hollowAmt * (1.0f - rand.nextFloat() * this.hollowVar)) : 0.0f;
                minDist *= minDist;
                for (int x = -xWidth; x <= xWidth; ++x) {
                    int xDist = x * x;
                    for (int z = -zWidth; z <= zWidth; ++z) {
                        int xzDist = xDist + z * z;
                        for (int y = -yWidth; y <= yWidth; ++y) {
                            int dist = xzDist + y * y;
                            if (!((float)dist <= maxDist)) continue;
                            if ((float)dist >= minDist) {
                                r |= WorldGenMinableCluster.generateBlock(world, rand, xCenter + x, yCenter + y, zCenter + z, this.cluster);
                                continue;
                            }
                            r |= world.func_175698_g(new BlockPos(xCenter + x, yCenter + y, zCenter + z));
                        }
                    }
                }
            }
            xCenter += rand.nextInt(var + minSize * 2) - (minSize + var / 2);
            zCenter += rand.nextInt(var + minSize * 2) - (minSize + var / 2);
            yCenter += rand.nextInt((var + 1) * 3) - (var + 1);
        }
        return r;
    }
}

