/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.armor;

import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemArmorCore;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RAProps;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemArmorFlux
extends ItemArmorCore
implements ISpecialArmor,
IEnergyContainerItem,
IEnchantableItem {
    private static final ISpecialArmor.ArmorProperties FLUX = new ISpecialArmor.ArmorProperties(0, 0.2, Integer.MAX_VALUE);
    private static final ISpecialArmor.ArmorProperties FALL = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    protected int maxEnergy = 800000;
    protected int maxTransfer = 4000;
    protected double absorbRatio = 0.9;
    protected int energyPerDamage = 200;

    public ItemArmorFlux(ItemArmor.ArmorMaterial material, EntityEquipmentSlot type) {
        super(material, type);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    public ItemArmorFlux setEnergyParams(int maxEnergy, int maxTransfer) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        return this;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Energy")) + " / " + StringHelper.formatNumber((long)this.getMaxEnergyStored(stack)) + " RF");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y)) {
            return enchantment.equals(Enchantments.field_185307_s);
        }
        return enchantment.field_77351_y.func_77557_a((Item)this);
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return RAProps.showArmorCharge && this.getEnergyStored(stack) > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return HashMultimap.create();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int absorbMax = this.energyPerDamage > 0 ? 25 * this.getEnergyStored(armor) / this.energyPerDamage : 0;
        return new ISpecialArmor.ArmorProperties(0, this.absorbRatio * (double)this.func_82812_d().func_78044_b(this.field_77881_a) * 0.05, absorbMax);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (this.getEnergyStored(armor) >= this.energyPerDamage) {
            return this.func_82812_d().func_78044_b(this.field_77881_a);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        if (source.field_76373_n.equals("flux")) {
            this.receiveEnergy(armor, damage * this.energyPerDamage, false);
        } else {
            int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)armor), (int)0, (int)10);
            if (MathHelper.RANDOM.nextInt(3 + unbreakingLevel) >= 3) {
                return;
            }
            this.extractEnergy(armor, damage * this.energyPerDamage, false);
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
    }

    public int getMaxEnergyStored(ItemStack container) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container);
        return this.maxEnergy + this.maxEnergy * enchant / 2;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

