/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.BlockThing;
import com.enderio.core.common.util.stackable.IProducer;
import com.enderio.core.common.util.stackable.IThing;
import com.enderio.core.common.util.stackable.ItemThing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

class ProducerThing
implements IThing {
    @Nonnull
    private final IProducer producer;

    ProducerThing(@Nonnull IProducer producer) {
        this.producer = producer;
    }

    @Override
    @Nullable
    public IThing bake() {
        Block block = this.producer.getBlock();
        if (block != null) {
            return new BlockThing(block).bake();
        }
        Item item = this.producer.getItem();
        if (item != null) {
            return new ItemThing(item).bake();
        }
        return null;
    }

    @Override
    public boolean is(@Nullable Item item) {
        return false;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean is(@Nullable Block block) {
        return false;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        return NNList.emptyList();
    }

    public String toString() {
        return String.format("ProducerThing []", new Object[0]);
    }
}

