/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChainList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPatternChain;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.List;
import java.util.Map;

public class CraftingPatternChainList
implements ICraftingPatternChainList {
    private Map<ICraftingPattern, CraftingPatternChain> map = new TCustomHashMap((HashingStrategy)new HashingStrategy<ICraftingPattern>(){

        public int computeHashCode(ICraftingPattern pattern) {
            return pattern.getChainHashCode();
        }

        public boolean equals(ICraftingPattern left, ICraftingPattern right) {
            return left.canBeInChainWith(right);
        }
    });

    public CraftingPatternChainList(List<ICraftingPattern> patterns) {
        for (ICraftingPattern pattern : patterns) {
            CraftingPatternChain chain = this.map.get(pattern);
            if (chain == null) {
                chain = new CraftingPatternChain();
                this.map.put(pattern, chain);
            }
            chain.addPattern(pattern);
        }
    }

    @Override
    public ICraftingPatternChain getChain(ICraftingPattern pattern) {
        ICraftingPatternChain chain = this.map.get(pattern);
        if (chain == null) {
            throw new IllegalStateException("Pattern was not found in pattern chain");
        }
        return chain;
    }
}

