/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeCrafter
extends NetworkNode
implements ICraftingPatternContainer {
    public static final String ID = "crafter";
    public static final String DEFAULT_NAME = "gui.refinedstorage:crafter";
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private ItemHandlerBase patterns = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[]{s -> NetworkNodeCrafter.isValidPatternInSlot(this.world, s)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeCrafter.this.world.field_72995_K) {
                NetworkNodeCrafter.this.rebuildPatterns();
            }
            if (NetworkNodeCrafter.this.network != null) {
                NetworkNodeCrafter.this.network.getCraftingManager().rebuild();
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2);
    private boolean visited = false;
    @Nullable
    private String displayName;
    @Nullable
    private UUID uuid = null;

    public static boolean isValidPatternInSlot(World world, ItemStack stack) {
        return stack.func_77973_b() instanceof ICraftingPatternProvider && ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, null).isValid();
    }

    public NetworkNodeCrafter(World world, BlockPos pos) {
        super(world, pos);
    }

    private void rebuildPatterns() {
        this.actualPatterns.clear();
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patterns.getStackInSlot(i);
            if (patternStack.func_190926_b() || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, this)).isValid()) continue;
            this.actualPatterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.crafterUsage + this.upgrades.getEnergyUsage() + RS.INSTANCE.config.crafterPerPatternUsage * this.actualPatterns.size();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.rebuildPatterns();
        }
    }

    @Override
    protected void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        if (!state) {
            network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
        }
        network.getCraftingManager().rebuild();
    }

    @Override
    protected void onDirectionChanged() {
        if (this.network != null) {
            this.network.getCraftingManager().rebuild();
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.patterns, 0, tag);
        if (API.instance().getOneSixMigrationHelper().migratePatternInventory((IItemHandler)this.patterns)) {
            this.markDirty();
        }
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_DISPLAY_NAME)) {
            this.displayName = tag.func_74779_i(NBT_DISPLAY_NAME);
        }
        if (tag.func_186855_b(NBT_UUID)) {
            this.uuid = tag.func_186857_a(NBT_UUID);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        if (this.displayName != null) {
            tag.func_74778_a(NBT_DISPLAY_NAME, this.displayName);
        }
        if (this.uuid != null) {
            tag.func_186854_a(NBT_UUID, this.uuid);
        }
        return tag;
    }

    @Override
    public int getSpeedUpgradeCount() {
        return this.upgrades.getUpgradeCount(2);
    }

    @Override
    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getItemHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getFluidHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public TileEntity getConnectedTile() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingTile();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patterns;
    }

    @Override
    public String getName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        TileEntity facing = this.getConnectedTile();
        if (facing instanceof IWorldNameable && ((IWorldNameable)facing).func_70005_c_() != null) {
            return ((IWorldNameable)facing).func_70005_c_();
        }
        if (facing != null) {
            return this.world.func_180495_p(this.pos.func_177972_a(this.getDirection())).func_177230_c().func_149739_a() + ".name";
        }
        return DEFAULT_NAME;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    public IItemHandler getPatternItems() {
        return this.patterns;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patterns, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager(this.world).getNode(this.pos.func_177972_a(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)((Object)facing)).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    @Override
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }
}

