/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItem;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeExternalStorage
extends NetworkNode
implements IStorageProvider,
IGuiStorage,
IComparable,
IFilterable,
IPrioritizable,
IType,
IAccessType,
IExternalStorageContext,
ICoverable {
    public static final String ID = "external_storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_COVERS = "Covers";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory fluidFilters = new FluidInventory(9, new ListenerNetworkNode(this));
    private int priority = 0;
    private int compare = 3;
    private int mode = 1;
    private int type = 0;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int networkTicks;
    private CoverManager coverManager = new CoverManager(this);
    private List<IStorageExternal<ItemStack>> itemStorages = new CopyOnWriteArrayList<IStorageExternal<ItemStack>>();
    private List<IStorageExternal<FluidStack>> fluidStorages = new CopyOnWriteArrayList<IStorageExternal<FluidStack>>();

    public NetworkNodeExternalStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.externalStorageUsage + (this.itemStorages.size() + this.fluidStorages.size()) * RS.INSTANCE.config.externalStoragePerStorageUsage;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        this.updateStorage(network);
    }

    @Override
    public void update() {
        super.update();
        if (this.network != null) {
            if (this.networkTicks++ == 0) {
                this.updateStorage(this.network);
                return;
            }
            for (IStorageExternal<ItemStack> iStorageExternal : this.itemStorages) {
                iStorageExternal.update(this.network);
            }
            for (IStorageExternal<ItemStack> iStorageExternal : this.fluidStorages) {
                iStorageExternal.update(this.network);
            }
        }
    }

    @Override
    protected void onDirectionChanged() {
        super.onDirectionChanged();
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilters.writeToNbt());
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
        OneSixMigrationHelper.migrateEmptyWhitelistToEmptyBlacklist(this.version, this, this.itemFilters);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public void updateStorage(INetwork network) {
        this.itemStorages.clear();
        this.fluidStorages.clear();
        TileEntity facing = this.getFacingTile();
        if (facing != null) {
            if (this.type == 0) {
                for (IExternalStorageProvider provider : API.instance().getExternalStorageProviders(StorageType.ITEM)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.itemStorages.add(provider.provide(this, () -> this.getFacingTile(), this.getDirection()));
                    break;
                }
            } else if (this.type == 1) {
                for (IExternalStorageProvider provider : API.instance().getExternalStorageProviders(StorageType.FLUID)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.fluidStorages.add(provider.provide(this, () -> this.getFacingTile(), this.getDirection()));
                    break;
                }
            }
        }
        network.getNodeGraph().addPostRebuildHandler(StorageCacheItem.INVALIDATE);
        network.getNodeGraph().addPostRebuildHandler(StorageCacheFluid.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileExternalStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileExternalStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileExternalStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileExternalStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileExternalStorage.ACCESS_TYPE;
    }

    @Override
    public int getStored() {
        return TileExternalStorage.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return TileExternalStorage.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return IFilterable.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, stack);
    }

    @Override
    public boolean acceptsFluid(FluidStack stack) {
        return IFilterable.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack);
    }

    @Override
    public void setAccessType(AccessType type) {
        this.accessType = type;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
            this.network.getFluidStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return TileExternalStorage.TYPE;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileExternalStorage.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public List<IStorageExternal<ItemStack>> getItemStorages() {
        return this.itemStorages;
    }

    public List<IStorageExternal<FluidStack>> getFluidStorages() {
        return this.fluidStorages;
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    @Nullable
    public IItemHandler getDrops() {
        return this.coverManager.getAsInventory();
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

