/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.storage.StorageDiskItemStorageWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItem;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.block.BlockStorage;
import com.raoulvdberge.refinedstorage.block.enums.ItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileStorage;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeStorage
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IComparable,
IFilterable,
IPrioritizable,
IAccessType,
IStorageDiskContainerContext {
    public static final String ID = "storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    public static final String NBT_ID = "Id";
    private ItemHandlerBase filters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private ItemStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 3;
    private int mode = 1;
    private UUID storageId = UUID.randomUUID();
    private IStorageDisk<ItemStack> storage;

    public NetworkNodeStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.storageUsage;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().addPostRebuildHandler(StorageCacheItem.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        if (this.storage == null) {
            this.loadStorage();
        }
        storages.add(this.storage);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_186854_a(NBT_ID, this.storageId);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_186855_b(NBT_ID)) {
            this.storageId = tag.func_186857_a(NBT_ID);
            this.loadStorage();
        }
        OneSixMigrationHelper.migrateItemStorageBlock(this, tag);
    }

    public void loadStorage() {
        IStorageDisk<ItemStack> disk = API.instance().getStorageDiskManager(this.world).get(this.storageId);
        if (disk == null) {
            disk = API.instance().createDefaultItemDisk(this.world, this.getType().getCapacity());
            API.instance().getStorageDiskManager(this.world).set(this.storageId, disk);
            API.instance().getStorageDiskManager(this.world).markForSaving();
        }
        this.storage = new StorageDiskItemStorageWrapper(this, disk);
    }

    public void setStorageId(UUID id) {
        this.storageId = id;
        this.markDirty();
    }

    public UUID getStorageId() {
        return this.storageId;
    }

    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
        OneSixMigrationHelper.migrateEmptyWhitelistToEmptyBlacklist(this.version, this, this.filters);
    }

    public ItemStorageType getType() {
        IBlockState state;
        if (this.type == null && this.world != null && (state = this.world.func_180495_p(this.pos)).func_177230_c() == RSBlocks.STORAGE) {
            this.type = (ItemStorageType)((Object)state.func_177229_b((IProperty)BlockStorage.TYPE));
        }
        return this.type == null ? ItemStorageType.TYPE_1K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public ItemHandlerBase getFilters() {
        return this.filters;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileStorage.ACCESS_TYPE;
    }

    @Override
    public int getStored() {
        return TileStorage.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
        }
    }
}

