/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StorageDiskItemPortable
implements IStorageDisk<ItemStack> {
    private IStorageDisk<ItemStack> parent;
    private IPortableGrid portableGrid;

    public StorageDiskItemPortable(IStorageDisk<ItemStack> parent, IPortableGrid portableGrid) {
        this.parent = parent;
        this.portableGrid = portableGrid;
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        int inserted;
        int storedPre = this.parent.getStored();
        ItemStack remainder = this.parent.insert(stack, size, action);
        if (action == Action.PERFORM && (inserted = this.parent.getCacheDelta(storedPre, size, remainder)) > 0) {
            this.portableGrid.getItemCache().add(stack, inserted, false, false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        ItemStack extracted = this.parent.extract(stack, size, flags, action);
        if (action == Action.PERFORM && extracted != null) {
            this.portableGrid.getItemCache().remove(extracted, extracted.func_190916_E(), false);
        }
        return extracted;
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }
}

