/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class StorageExternalFluid
implements IStorageExternal<FluidStack> {
    private IExternalStorageContext context;
    private Supplier<IFluidHandler> handlerSupplier;
    private List<FluidStack> cache;
    private boolean connectedToInterface;

    public StorageExternalFluid(IExternalStorageContext context, Supplier<IFluidHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Nullable
    private IFluidTankProperties[] getProperties() {
        IFluidHandler handler = this.handlerSupplier.get();
        return handler != null && handler.getTankProperties() != null && handler.getTankProperties().length != 0 ? handler.getTankProperties() : null;
    }

    @Override
    public void update(INetwork network) {
        int i;
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<FluidStack>(this.getStacksWithNulls());
            return;
        }
        ArrayList<FluidStack> newStacks = new ArrayList<FluidStack>(this.getStacksWithNulls());
        for (i = 0; i < newStacks.size(); ++i) {
            FluidStack actual = (FluidStack)newStacks.get(i);
            if (i >= this.cache.size()) {
                if (actual == null) continue;
                network.getFluidStorageCache().add(actual, actual.amount, false, true);
                continue;
            }
            FluidStack cached = this.cache.get(i);
            if (actual == null && cached == null) continue;
            if (actual == null && cached != null) {
                network.getFluidStorageCache().remove(cached, cached.amount, true);
                continue;
            }
            if (actual != null && cached == null) {
                network.getFluidStorageCache().add(actual, actual.amount, false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, actual.amount);
                continue;
            }
            if (!API.instance().getComparer().isEqual(actual, cached, 2)) {
                network.getFluidStorageCache().remove(cached, cached.amount, true);
                network.getFluidStorageCache().add(actual, actual.amount, false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, actual.amount);
                continue;
            }
            if (actual.amount > cached.amount) {
                network.getFluidStorageCache().add(actual, actual.amount - cached.amount, false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, actual.amount - cached.amount);
                continue;
            }
            if (actual.amount >= cached.amount) continue;
            network.getFluidStorageCache().remove(actual, cached.amount - actual.amount, true);
        }
        if (this.cache.size() > newStacks.size()) {
            for (i = newStacks.size(); i < this.cache.size(); ++i) {
                if (this.cache.get(i) == null) continue;
                network.getFluidStorageCache().remove(this.cache.get(i), this.cache.get((int)i).amount, true);
            }
        }
        this.cache = newStacks;
        network.getFluidStorageCache().flush();
    }

    @Override
    public int getCapacity() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            int cap = 0;
            for (IFluidTankProperties properties : props) {
                cap += properties.getCapacity();
            }
            return cap;
        }
        return 0;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (IFluidTankProperties properties : props) {
                FluidStack stack = properties.getContents();
                if (stack == null) continue;
                fluids.add(stack.copy());
            }
            return fluids;
        }
        return Collections.emptyList();
    }

    private Collection<FluidStack> getStacksWithNulls() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (IFluidTankProperties properties : props) {
                FluidStack stack = properties.getContents();
                if (stack != null) {
                    fluids.add(stack.copy());
                    continue;
                }
                fluids.add(null);
            }
            return fluids;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        if (this.context.acceptsFluid(stack)) {
            int filled = this.handlerSupplier.get().fill(StackUtils.copy(stack, size), action == Action.PERFORM);
            if (filled == size) {
                return null;
            }
            return StackUtils.copy(stack, size - filled);
        }
        return StackUtils.copy(stack, size);
    }

    @Override
    @Nullable
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        IFluidHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        return handler.drain(StackUtils.copy(stack, size), action == Action.PERFORM);
    }

    @Override
    public int getStored() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            int stored = 0;
            for (IFluidTankProperties properties : props) {
                FluidStack contents = properties.getContents();
                if (contents == null) continue;
                stored += contents.amount;
            }
            return stored;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.amount;
    }
}

