/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackListItem
implements IStackList<ItemStack> {
    private ArrayListMultimap<Item, ItemStack> stacks = ArrayListMultimap.create();

    @Override
    public void add(@Nonnull ItemStack stack, int size) {
        if (stack == null || stack.func_190926_b() || size <= 0) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if ((long)otherStack.func_190916_E() + (long)size > Integer.MAX_VALUE) {
                otherStack.func_190920_e(Integer.MAX_VALUE);
            } else {
                otherStack.func_190917_f(size);
            }
            return;
        }
        this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
    }

    @Override
    public void add(@Nonnull ItemStack stack) {
        this.add(stack, stack.func_190916_E());
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack, int size) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            boolean success;
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            boolean bl = success = otherStack.func_190916_E() - size >= 0;
            if (otherStack.func_190916_E() - size <= 0) {
                this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
            } else {
                otherStack.func_190918_g(size);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack) {
        return this.remove(stack, stack.func_190916_E());
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        for (ItemStack stack : this.stacks.values()) {
            if (API.instance().getItemStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> copy() {
        StackListItem list = new StackListItem();
        for (ItemStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.func_77973_b(), (Object)stack.func_77946_l());
        }
        return list;
    }
}

