/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockNodeProxy
extends BlockBase {
    public BlockNodeProxy(IBlockInfo info) {
        super(info);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        Object node;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null) && (node = ((INetworkNodeProxy)tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null)).getNode()).getNetwork() != null) {
            return entity instanceof EntityPlayer && node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, (EntityPlayer)entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K && this.getDirection() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            EnumFacing newDirection = this.getDirection().cycle(tile.getDirection());
            if (tile instanceof TileNode && ((TileNode)tile).getNode() instanceof ICoverable && ((ICoverable)((Object)((TileNode)tile).getNode())).getCoverManager().hasCover(newDirection)) {
                return false;
            }
        }
        return super.rotateBlock(world, pos, axis);
    }

    protected boolean openNetworkGui(int guiId, EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
        return this.openNetworkGui(guiId, player, world, pos, facing, Permission.MODIFY);
    }

    protected boolean openNetworkGui(int guiId, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, Permission ... permissions) {
        INetworkNodeProxy nodeProxy;
        Object node;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing) && (node = (nodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing))).getNode()).getNetwork() != null) {
            for (Permission permission : permissions) {
                if (node.getNetwork().getSecurityManager().hasPermission(permission, player)) continue;
                WorldUtils.sendNoPermissionMessage(player);
                return false;
            }
        }
        player.openGui(this.info.getModObject(), guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }
}

