/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.enums.PortableGridDiskState;
import com.raoulvdberge.refinedstorage.block.enums.PortableGridType;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.block.info.BlockInfoBuilder;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockPortableGrid;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsPortableGrid;
import com.raoulvdberge.refinedstorage.render.meshdefinition.ItemMeshDefinitionPortableGrid;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelFullbright;
import com.raoulvdberge.refinedstorage.tile.grid.portable.TilePortableGrid;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortableGrid
extends BlockBase {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", PortableGridType.class);
    public static final PropertyEnum DISK_STATE = PropertyEnum.func_177709_a((String)"disk_state", PortableGridDiskState.class);
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    public BlockPortableGrid() {
        super(BlockInfoBuilder.forId("portable_grid").tileEntity(TilePortableGrid::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setStateMapper(this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{TYPE}).func_178441_a());
        modelRegistration.setModelMeshDefinition(this, new ItemMeshDefinitionPortableGrid());
        modelRegistration.addBakedModelOverride(this.info.getId(), base -> new BakedModelFullbright((IBakedModel)base, "refinedstorage:blocks/disks/leds"));
    }

    @Override
    @Nullable
    public BlockDirection getDirection() {
        return BlockDirection.HORIZONTAL;
    }

    @Override
    public Item createItem() {
        return new ItemBlockPortableGrid(this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ConstantsPortableGrid.PORTABLE_GRID_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            ((TilePortableGrid)world.func_175625_s(pos)).onPassItemContext(stack);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)((TilePortableGrid)world.func_175625_s(pos)).getAsItem());
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TilePortableGrid portableGrid = (TilePortableGrid)world.func_175625_s(pos);
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)DISK_STATE, (Comparable)((Object)portableGrid.getDiskState())).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(portableGrid.isConnected()));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().add(new IProperty[]{TYPE}).add(new IProperty[]{DISK_STATE}).add(new IProperty[]{CONNECTED}).build();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)(meta == 0 ? PortableGridType.NORMAL : PortableGridType.CREATIVE)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)TYPE) == PortableGridType.NORMAL ? 0 : 1;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)RS.INSTANCE, 26, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            ((TilePortableGrid)world.func_175625_s(pos)).onOpened();
        }
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

