/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;

public class GridStackFluid
implements IGridStack {
    private int hash;
    private FluidStack stack;
    @Nullable
    private IStorageTracker.IStorageTrackerEntry entry;
    private boolean craftable;
    private boolean displayCraftText;

    public GridStackFluid(int hash, FluidStack stack, @Nullable IStorageTracker.IStorageTrackerEntry entry, boolean craftable, boolean displayCraftText) {
        this.hash = hash;
        this.stack = stack;
        this.entry = entry;
        this.craftable = craftable;
        this.displayCraftText = displayCraftText;
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public boolean doesDisplayCraftText() {
        return this.displayCraftText;
    }

    @Override
    public void setDisplayCraftText(boolean displayCraftText) {
        this.displayCraftText = displayCraftText;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public String getModId() {
        return this.stack.getFluid().getStill(this.stack).func_110624_b();
    }

    @Override
    public String[] getOreIds() {
        return new String[]{this.stack.getFluid().getName()};
    }

    @Override
    public String getTooltip() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getQuantity() {
        return this.stack.amount;
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity()) + " mB";
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        GuiBase.FLUID_RENDERER.draw(gui.field_146297_k, x, y, this.stack);
        String text = this.displayCraftText ? I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]) : API.instance().getQuantityFormatter().formatInBucketFormWithOnlyTrailingDigitsIfZero(this.getQuantity());
        gui.drawQuantity(x, y, text);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageTracker.IStorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.entry = entry;
    }
}

