/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.direction.DirectionHandlerTile;
import com.raoulvdberge.refinedstorage.tile.direction.IDirectionHandler;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class TileBase
extends TileEntity {
    protected static final String NBT_DIRECTION = "Direction";
    private EnumFacing clientDirection = EnumFacing.NORTH;
    protected IDirectionHandler directionHandler = new DirectionHandlerTile();
    protected TileDataManager dataManager = new TileDataManager(this);

    public void setDirection(EnumFacing direction) {
        this.clientDirection = direction;
        this.directionHandler.setDirection(direction);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
        this.func_70296_d();
    }

    public EnumFacing getDirection() {
        return this.field_145850_b.field_72995_K ? this.clientDirection : this.directionHandler.getDirection();
    }

    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        this.directionHandler.writeToTileNbt(tag);
        return tag;
    }

    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        tag.func_74768_a(NBT_DIRECTION, this.directionHandler.getDirection().ordinal());
        return tag;
    }

    public void read(NBTTagCompound tag) {
        this.directionHandler.readFromTileNbt(tag);
    }

    public void readUpdate(NBTTagCompound tag) {
        boolean doRender = this.canCauseRenderUpdate(tag);
        this.clientDirection = EnumFacing.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
        if (doRender) {
            WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    protected boolean canCauseRenderUpdate(NBTTagCompound tag) {
        return true;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.writeUpdate(super.func_189517_E_());
    }

    @Nullable
    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readUpdate(packet.func_148857_g());
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readUpdate(tag);
    }

    public final void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.read(tag);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.write(super.func_189515_b(tag));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public IItemHandler getDrops() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof TileBase && ((TileBase)((Object)o)).func_174877_v().equals((Object)this.field_174879_c) && ((TileBase)((Object)o)).field_145850_b.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension();
    }

    public int hashCode() {
        int result = this.field_174879_c.hashCode();
        result = 31 * result + this.field_145850_b.field_73011_w.getDimension();
        return result;
    }
}

