/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerFactory;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiReaderWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeReader;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.GuiReaderWriter;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileReader
extends TileNode<NetworkNodeReader> {
    public static final TileDataParameter<String, TileReader> CHANNEL = TileReader.createChannelParameter();

    static <T extends TileNode> TileDataParameter<String, T> createChannelParameter() {
        return new TileDataParameter<String, TileNode>(DataSerializers.field_187194_d, "", t -> ((IGuiReaderWriter)((Object)t.getNode())).getChannel(), (t, v) -> {
            ((IGuiReaderWriter)((Object)t.getNode())).setChannel((String)v);
            ((NetworkNode)t.getNode()).markDirty();
        }, (initial, p) -> GuiBase.executeLater(GuiReaderWriter.class, readerWriter -> readerWriter.setCurrentChannel((String)p)));
    }

    public TileReader() {
        this.dataManager.addWatchedParameter(CHANNEL);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        IReader reader = (IReader)this.getNode();
        if (facing != this.getDirection()) {
            return false;
        }
        for (IReaderWriterHandlerFactory handlerFactory : API.instance().getReaderWriterHandlerRegistry().all()) {
            if (!handlerFactory.create(null).hasCapabilityReader(reader, capability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T foundCapability = super.getCapability(capability, facing);
        if (foundCapability == null) {
            IReader reader = (IReader)this.getNode();
            if (facing != this.getDirection()) {
                return null;
            }
            Object dummyCap = null;
            for (IReaderWriterHandlerFactory handlerFactory : API.instance().getReaderWriterHandlerRegistry().all()) {
                if (!handlerFactory.create(null).hasCapabilityReader(reader, capability)) continue;
                dummyCap = handlerFactory.create(null).getNullCapability();
            }
            if (reader.getNetwork() == null || !reader.canUpdate()) {
                return (T)dummyCap;
            }
            IReaderWriterChannel channel = reader.getNetwork().getReaderWriterManager().getChannel(reader.getChannel());
            if (channel == null) {
                return (T)dummyCap;
            }
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                foundCapability = handler.getCapabilityReader(reader, capability);
                if (foundCapability == null) continue;
                return foundCapability;
            }
        }
        return foundCapability;
    }

    @Override
    @Nonnull
    public NetworkNodeReader createNode(World world, BlockPos pos) {
        return new NetworkNodeReader(world, pos);
    }

    @Override
    public String getNodeId() {
        return "reader";
    }
}

