/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.data;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.tile.ClientNode;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class RSSerializers {
    public static final DataSerializer<List<ClientNode>> CLIENT_NODE_SERIALIZER = new DataSerializer<List<ClientNode>>(){

        public void write(PacketBuffer buf, List<ClientNode> nodes) {
            buf.writeInt(nodes.size());
            for (ClientNode node : nodes) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)node.getStack());
                buf.writeInt(node.getAmount());
                buf.writeInt(node.getEnergyUsage());
            }
        }

        public List<ClientNode> read(PacketBuffer buf) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                nodes.add(new ClientNode(ByteBufUtils.readItemStack((ByteBuf)buf), buf.readInt(), buf.readInt()));
            }
            return nodes;
        }

        public DataParameter<List<ClientNode>> func_187161_a(int id) {
            return null;
        }

        public List<ClientNode> copyValue(List<ClientNode> value) {
            return value;
        }
    };
    public static final DataSerializer<FluidStack> FLUID_STACK_SERIALIZER = new DataSerializer<FluidStack>(){

        public void write(PacketBuffer buf, FluidStack value) {
            if (value == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((FluidStack)value));
                buf.writeInt(value.amount);
                buf.func_150786_a(value.tag);
            }
        }

        public FluidStack read(PacketBuffer buf) {
            try {
                if (buf.readBoolean()) {
                    return new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), buf.func_150793_b());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public DataParameter<FluidStack> func_187161_a(int id) {
            return null;
        }

        public FluidStack copyValue(FluidStack value) {
            return value;
        }
    };
    public static final DataSerializer<AccessType> ACCESS_TYPE_SERIALIZER = new DataSerializer<AccessType>(){

        public void write(PacketBuffer buf, AccessType value) {
            buf.writeInt(value.getId());
        }

        public AccessType read(PacketBuffer buf) {
            return AccessTypeUtils.getAccessType(buf.readInt());
        }

        public DataParameter<AccessType> func_187161_a(int id) {
            return null;
        }

        public AccessType copyValue(AccessType value) {
            return value;
        }
    };
}

