/*
 * Decompiled with CFR 0.152.
 */
package com.knoxhack.nethermetals.world;

import com.google.common.base.Predicate;
import com.knoxhack.nethermetals.ConfigHandler;
import com.knoxhack.nethermetals.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    private WorldGenerator gen_nether_coal_ore = new WorldGenMinable(ModBlocks.nethercoalOre.func_176223_P(), ConfigHandler.getNetherCoalOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_diamond_ore = new WorldGenMinable(ModBlocks.netherdiamondOre.func_176223_P(), ConfigHandler.getNetherDiamondOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_emerald_ore = new WorldGenMinable(ModBlocks.netheremeraldOre.func_176223_P(), ConfigHandler.getNetherEmeraldOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_gold_ore = new WorldGenMinable(ModBlocks.nethergoldOre.func_176223_P(), ConfigHandler.getNetherGoldOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_iron_ore = new WorldGenMinable(ModBlocks.netherironOre.func_176223_P(), ConfigHandler.getNetherIronOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_lapis_ore = new WorldGenMinable(ModBlocks.netherlapisOre.func_176223_P(), ConfigHandler.getNetherLapisOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_nether_redstone_ore = new WorldGenMinable(ModBlocks.netherredstoneOre.func_176223_P(), ConfigHandler.getNetherRedstoneOreSpawnProb(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                break;
            }
            case -1: {
                this.runGenerator(this.gen_nether_coal_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_diamond_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_emerald_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_gold_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_iron_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_lapis_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                this.runGenerator(this.gen_nether_redstone_ore, world, random, chunkX, chunkZ, 5, 0, 200);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

