/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.api;

import java.util.HashSet;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.translation.I18n;

public enum ChunkLoaderShape {
    Square("square"),
    Circle("circle"),
    LineX("linex"),
    LineZ("linez");

    String name;

    private ChunkLoaderShape(String s) {
        this.name = s;
    }

    public HashSet<ChunkPos> getChunks(int radius, ChunkPos center) {
        HashSet<ChunkPos> chunkset = new HashSet<ChunkPos>();
        --radius;
        switch (this) {
            case Square: {
                for (int x = center.field_77276_a - radius; x <= center.field_77276_a + radius; ++x) {
                    for (int z = center.field_77275_b - radius; z <= center.field_77275_b + radius; ++z) {
                        chunkset.add(new ChunkPos(x, z));
                    }
                }
                break;
            }
            case LineX: {
                for (int x = center.field_77276_a - radius; x <= center.field_77276_a + radius; ++x) {
                    chunkset.add(new ChunkPos(x, center.field_77275_b));
                }
                break;
            }
            case LineZ: {
                for (int z = center.field_77275_b - radius; z <= center.field_77275_b + radius; ++z) {
                    chunkset.add(new ChunkPos(center.field_77276_a, z));
                }
                break;
            }
            case Circle: {
                for (int x = center.field_77276_a - radius; x <= center.field_77276_a + radius; ++x) {
                    for (int z = center.field_77275_b - radius; z <= center.field_77275_b + radius; ++z) {
                        int relx = x - center.field_77276_a;
                        int relz = z - center.field_77275_b;
                        double dist = Math.sqrt(relx * relx + relz * relz);
                        if (!(dist <= (double)radius)) continue;
                        chunkset.add(new ChunkPos(x, z));
                    }
                }
                break;
            }
        }
        return chunkset;
    }

    public ChunkLoaderShape next() {
        int index = this.ordinal();
        if (++index == ChunkLoaderShape.values().length) {
            index = 0;
        }
        return ChunkLoaderShape.values()[index];
    }

    public ChunkLoaderShape prev() {
        int index = this.ordinal();
        if (--index == -1) {
            index = ChunkLoaderShape.values().length - 1;
        }
        return ChunkLoaderShape.values()[index];
    }

    public HashSet<ChunkPos> getLoadedChunks(int chunkx, int chunkz, int radius) {
        HashSet<ChunkPos> chunkSet = new HashSet<ChunkPos>();
        switch (this) {
            case Square: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        chunkSet.add(new ChunkPos(cx, cz));
                    }
                }
                break;
            }
            case LineX: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    chunkSet.add(new ChunkPos(cx, chunkz));
                }
                break;
            }
            case LineZ: {
                for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                    chunkSet.add(new ChunkPos(chunkx, cz));
                }
                break;
            }
            case Circle: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        double distSquared = (cx - chunkx) * (cx - chunkx) + (cz - chunkz) * (cz - chunkz);
                        if (!(distSquared <= (double)(radius * radius))) continue;
                        chunkSet.add(new ChunkPos(cx, cz));
                    }
                }
                break;
            }
        }
        return chunkSet;
    }

    public String getName() {
        return I18n.func_74838_a((String)("chickenchunks.shape." + this.name));
    }
}

