/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.DeathPosition;
import de.maxhenkel.gravestone.MBlocks;
import de.maxhenkel.gravestone.MItems;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.TileEntityGraveStone;
import de.maxhenkel.gravestone.Tools;
import de.maxhenkel.gravestone.UpdateChecker;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Events {
    public static final String KEY_CHECK_UPDATES = "check_updates";
    public static final String KEY_DEATH_NOTE = "enable_death_note";
    public static final String KEY_LIVING_GRAVES = "enable_living_entity_graves";
    public static final String KEY_REMOVE_DEATH_NOTE = "remove_death_note";
    public static final String KEY_ONLY_OWNERS_CAN_BREAK = "only_owners_can_break";
    private boolean checkUpdates = Main.getInstance().getConfig().getBoolean("check_updates", true);
    private boolean updateShown = false;
    private boolean givePlayerNote = Main.getInstance().getConfig().getBoolean("enable_death_note", true);
    private boolean livingGraves = Main.getInstance().getConfig().getBoolean("enable_living_entity_graves", false);
    private boolean removeDeathNote = Main.getInstance().getConfig().getBoolean("remove_death_note", false);
    private boolean onlyOwnersCanBreak = Main.getInstance().getConfig().getBoolean("only_owners_can_break", false);

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (!event.getState().func_177230_c().equals(MBlocks.GRAVESTONE)) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (!(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)te;
        ItemStack stack = event.getItemInHand();
        if (stack == null || !stack.func_77973_b().equals(Item.func_150898_a((Block)MBlocks.GRAVESTONE))) {
            return;
        }
        if (!stack.func_82837_s()) {
            return;
        }
        String name = stack.func_82833_r();
        if (name == null) {
            return;
        }
        graveTileEntity.setPlayerName(name);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        this.removeDeathNote(event);
        this.checkBreak(event);
    }

    public void removeDeathNote(BlockEvent.BreakEvent event) {
        if (!this.removeDeathNote) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (!event.getState().func_177230_c().equals(MBlocks.GRAVESTONE)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        InventoryPlayer inv = player.field_71071_by;
        BlockPos pos = event.getPos();
        int dim = player.field_71093_bK;
        for (ItemStack stack : inv.field_70462_a) {
            DeathInfo info;
            if (stack == null || !stack.func_77973_b().equals(MItems.DEATH_INFO) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("info") || (info = DeathInfo.fromNBT(stack.func_77978_p().func_74775_l("info"))) == null || dim != info.getDimension() || !pos.equals((Object)info.getDeathLocation())) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_70460_b) {
            if (stack == null || !stack.func_77973_b().equals(MItems.DEATH_INFO)) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_184439_c) {
            if (stack == null || !stack.func_77973_b().equals(MItems.DEATH_INFO)) continue;
            inv.func_184437_d(stack);
        }
    }

    public void checkBreak(BlockEvent.BreakEvent event) {
        EntityPlayerMP p;
        boolean isOp;
        if (!this.onlyOwnersCanBreak) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (!event.getState().func_177230_c().equals(MBlocks.GRAVESTONE)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        String uuid = tileentity.getPlayerUUID();
        if (uuid == null) {
            return;
        }
        if (player.func_110124_au().toString().equals(uuid)) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            event.setCanceled(true);
        }
        if (!(isOp = (p = (EntityPlayerMP)player).func_70003_b(p.field_71133_b.func_110455_j(), "op"))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!this.givePlayerNote) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getEntityPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getEntityPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) && !this.livingGraves) {
            return;
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        try {
            List drops = event.getDrops();
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            DeathPosition deathPos = new DeathPosition(entity);
            if (deathPos.placeGraveStone(drops)) {
                event.setCanceled(true);
            }
            if (this.givePlayerNote) {
                deathPos.givePlayerNote();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathPosition.givePlayerNote(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable) {
                if (isAvailable) {
                    String msg = "[" + new TextComponentTranslation("message.name", new Object[0]).func_150254_d() + "] " + new TextComponentTranslation("message.update", new Object[0]).func_150254_d() + " ";
                    ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/projects/gravestone-mod");
                    Style style = new Style();
                    style.func_150241_a(openUrl);
                    style.func_150228_d(Boolean.valueOf(true));
                    style.func_150238_a(TextFormatting.GREEN);
                    style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(new TextComponentTranslation("message.update.hover", new Object[0]).func_150254_d())));
                    TextComponentString comp = new TextComponentString("[Download]");
                    comp.func_150255_a(style);
                    player.func_145747_a(new TextComponentString(msg).func_150257_a((ITextComponent)comp));
                }
            }
        }, 20, "http://maxhenkel.de/update/gravestone_1.10.2.txt");
        checker.start();
        this.updateShown = true;
    }
}

