/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import javax.annotation.Nullable;
import mezz.jei.IngredientRegistry;
import mezz.jei.JeiRuntime;
import mezz.jei.RecipeRegistry;
import mezz.jei.config.Config;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.input.InputHandler;
import mezz.jei.util.Translator;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    private static final String showRecipesText = Translator.translateToLocal("jei.tooltip.show.recipes");
    private final JeiRuntime runtime;
    @Nullable
    private InputHandler inputHandler;
    @Nullable
    private GuiContainer previousGui = null;

    public GuiEventHandler(JeiRuntime runtime) {
        this.runtime = runtime;
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        ItemListOverlay itemListOverlay = this.runtime.getItemListOverlay();
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)gui;
            itemListOverlay.initGui((GuiScreen)guiContainer);
            RecipeRegistry recipeRegistry = this.runtime.getRecipeRegistry();
            IngredientRegistry ingredientRegistry = this.runtime.getIngredientRegistry();
            RecipesGui recipesGui = this.runtime.getRecipesGui();
            this.inputHandler = new InputHandler(recipeRegistry, ingredientRegistry, recipesGui, itemListOverlay);
        } else if (gui instanceof RecipesGui) {
            if (this.inputHandler != null) {
                this.inputHandler.onScreenResized();
            }
        } else {
            this.inputHandler = null;
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        ItemListOverlay itemListOverlay = this.runtime.getItemListOverlay();
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)gui;
            if (this.previousGui != guiContainer) {
                this.previousGui = guiContainer;
                if (itemListOverlay.isOpen()) {
                    itemListOverlay.close();
                }
            }
        } else if (!(gui instanceof RecipesGui) && itemListOverlay.isOpen()) {
            itemListOverlay.close();
        }
    }

    @SubscribeEvent
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent event) {
        ItemListOverlay itemListOverlay = this.runtime.getItemListOverlay();
        if (itemListOverlay.isOpen()) {
            GuiScreen gui = event.getGui();
            itemListOverlay.updateGui(gui);
            itemListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        ItemListOverlay itemListOverlay;
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)gui;
            RecipeRegistry recipeRegistry = this.runtime.getRecipeRegistry();
            if (recipeRegistry.getRecipeClickableArea(guiContainer, event.getMouseX() - guiContainer.field_147003_i, event.getMouseY() - guiContainer.field_147009_r) != null) {
                TooltipRenderer.drawHoveringText(guiContainer.field_146297_k, showRecipesText, event.getMouseX(), event.getMouseY());
            }
        }
        if ((itemListOverlay = this.runtime.getItemListOverlay()).isOpen()) {
            itemListOverlay.drawTooltips(gui.field_146297_k, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ItemListOverlay itemListOverlay = this.runtime.getItemListOverlay();
        if (itemListOverlay.isOpen()) {
            itemListOverlay.handleTick();
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (this.inputHandler != null && this.inputHandler.handleKeyEvent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        int y;
        int x;
        GuiScreen guiScreen = event.getGui();
        if (this.inputHandler != null && this.inputHandler.handleMouseEvent(guiScreen, x = Mouse.getEventX() * guiScreen.field_146294_l / guiScreen.field_146297_k.field_71443_c, y = guiScreen.field_146295_m - Mouse.getEventY() * guiScreen.field_146295_m / guiScreen.field_146297_k.field_71440_d - 1)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (Config.isOverlayEnabled()) {
            event.setCanceled(true);
        }
    }
}

