/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.ItemBlacklist;
import mezz.jei.JeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.util.IngredientListElement;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import mezz.jei.util.ModIdUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;

public class IngredientBaseListFactory {
    private IngredientBaseListFactory() {
    }

    public static ImmutableList<IIngredientListElement> create(IIngredientRegistry ingredientRegistry, JeiHelpers jeiHelpers) {
        IngredientChecker ingredientChecker = new IngredientChecker(jeiHelpers);
        LinkedList<IIngredientListElement> ingredientListElements = new LinkedList<IIngredientListElement>();
        for (Class ingredientClass : ingredientRegistry.getRegisteredIngredientClasses()) {
            IngredientBaseListFactory.addToBaseList(ingredientListElements, ingredientRegistry, ingredientChecker, ingredientClass);
        }
        for (Multiset.Entry brokenItem : ingredientChecker.getBrokenItems().entrySet()) {
            int count = brokenItem.getCount();
            if (count <= 1) continue;
            Item item = (Item)brokenItem.getElement();
            IIngredientHelper<ItemStack> ingredientHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
            String modId = ingredientHelper.getModId(new ItemStack(item));
            String modName = Internal.getModIdUtil().getModNameForModId(modId);
            Log.error("Couldn't get ItemModel for {} item {}. Suppressed {} similar errors.", modName, item, count);
        }
        IngredientBaseListFactory.sortIngredientListElements(ingredientListElements);
        return ImmutableList.copyOf(ingredientListElements);
    }

    private static <V> List<IIngredientListElement> addToBaseList(List<IIngredientListElement> baseList, IIngredientRegistry ingredientRegistry, IngredientChecker ingredientChecker, Class<V> ingredientClass) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        for (Object ingredient : ingredientRegistry.getIngredients(ingredientClass)) {
            IngredientListElement ingredientListElement;
            if (ingredient == null || ingredientChecker.isIngredientHidden(ingredient, ingredientHelper) || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer)) == null) continue;
            baseList.add(ingredientListElement);
        }
        return baseList;
    }

    private static void sortIngredientListElements(List<IIngredientListElement> ingredientListElements) {
        int index = 0;
        final HashMap<String, Integer> itemAddedOrder = new HashMap<String, Integer>();
        for (IIngredientListElement ingredientListElement : ingredientListElements) {
            String uid = IngredientBaseListFactory.getWildcardUid(ingredientListElement);
            if (itemAddedOrder.containsKey(uid)) continue;
            itemAddedOrder.put(uid, index);
            ++index;
        }
        Collections.sort(ingredientListElements, new Comparator<IIngredientListElement>(){

            @Override
            public int compare(IIngredientListElement o1, IIngredientListElement o2) {
                String modName2;
                String modName1 = IngredientBaseListFactory.getModName(o1);
                if (modName1.equals(modName2 = IngredientBaseListFactory.getModName(o2))) {
                    boolean isItemStack1 = o1.getIngredient() instanceof ItemStack;
                    boolean isItemStack2 = o2.getIngredient() instanceof ItemStack;
                    if (isItemStack1 && !isItemStack2) {
                        return -1;
                    }
                    if (!isItemStack1 && isItemStack2) {
                        return 1;
                    }
                    String uid1 = IngredientBaseListFactory.getWildcardUid(o1);
                    String uid2 = IngredientBaseListFactory.getWildcardUid(o2);
                    int orderIndex1 = (Integer)itemAddedOrder.get(uid1);
                    int orderIndex2 = (Integer)itemAddedOrder.get(uid2);
                    return Java6Helper.compare(orderIndex1, orderIndex2);
                }
                if (modName1.equals("Minecraft")) {
                    return -1;
                }
                if (modName2.equals("Minecraft")) {
                    return 1;
                }
                return modName1.compareTo(modName2);
            }
        });
    }

    private static <V> String getModName(IIngredientListElement<V> ingredientListElement) {
        V ingredient = ingredientListElement.getIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientListElement.getIngredientHelper();
        String modId = ingredientHelper.getModId(ingredient);
        return Internal.getModIdUtil().getModNameForModId(modId);
    }

    private static <V> String getWildcardUid(IIngredientListElement<V> ingredientListElement) {
        V ingredient = ingredientListElement.getIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientListElement.getIngredientHelper();
        return ingredientHelper.getWildcardId(ingredient);
    }

    private static class IngredientChecker {
        private final ItemBlacklist itemBlacklist;
        private final ItemModelMesher itemModelMesher;
        private final IBakedModel missingModel;
        private final Multiset<Item> brokenItems = HashMultiset.create();

        public IngredientChecker(JeiHelpers jeiHelpers) {
            this.itemBlacklist = jeiHelpers.getItemBlacklist();
            this.itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            this.missingModel = this.itemModelMesher.func_178083_a().func_174951_a();
        }

        public <V> boolean isIngredientHidden(V ingredient, IIngredientHelper<V> ingredientHelper) {
            if (this.isIngredientHiddenByBlacklist(ingredient, ingredientHelper)) {
                return true;
            }
            if (ingredient instanceof ItemStack) {
                IBakedModel itemModel;
                ItemStack itemStack = (ItemStack)ingredient;
                Item item = itemStack.func_77973_b();
                if (this.brokenItems.contains((Object)item)) {
                    return true;
                }
                RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
                try {
                    itemModel = renderItem.func_184393_a(itemStack, null, null);
                }
                catch (RuntimeException e) {
                    ModIdUtil modIdUtil = Internal.getModIdUtil();
                    String modName = modIdUtil.getModNameForIngredient(ingredient, ingredientHelper);
                    String stackInfo = ingredientHelper.getErrorInfo(ingredient);
                    Log.error("Couldn't get ItemModel for {} itemStack {}", modName, stackInfo, e);
                    this.brokenItems.add((Object)item);
                    return true;
                }
                catch (LinkageError e) {
                    ModIdUtil modIdUtil = Internal.getModIdUtil();
                    String modName = modIdUtil.getModNameForIngredient(ingredient, ingredientHelper);
                    String stackInfo = ingredientHelper.getErrorInfo(ingredient);
                    Log.error("Couldn't get ItemModel for {} itemStack {}", modName, stackInfo, e);
                    this.brokenItems.add((Object)item);
                    return true;
                }
                if (Config.isHideMissingModelsEnabled() && (itemModel == null || itemModel == this.missingModel)) {
                    return true;
                }
                if (item instanceof ItemSkull && itemStack.func_77960_j() == 3) {
                    return true;
                }
            }
            return false;
        }

        public Multiset<Item> getBrokenItems() {
            return this.brokenItems;
        }

        private <V> boolean isIngredientHiddenByBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
            try {
                if (ingredient instanceof ItemStack && this.itemBlacklist.isItemBlacklistedByApi((ItemStack)ingredient)) {
                    return true;
                }
                if (!Config.isEditModeEnabled() && Config.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.error("Could not check blacklist for ingredient {}", ingredientInfo, e);
                return true;
            }
            return false;
        }
    }
}

