/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;

public class IngredientRegistry
implements IIngredientRegistry {
    private final ImmutableMap<Class, ImmutableList> ingredientsMap;
    private final ImmutableMap<Class, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap;
    private final ImmutableList<ItemStack> fuels;
    private final ImmutableList<ItemStack> potionIngredients;

    public IngredientRegistry(ImmutableMap<Class, ImmutableList> ingredientsMap, ImmutableMap<Class, IIngredientHelper> ingredientHelperMap, ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap) {
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        IIngredientHelper<ItemStack> itemStackHelper = this.getIngredientHelper(ItemStack.class);
        ImmutableList.Builder fuelsBuilder = ImmutableList.builder();
        ImmutableList.Builder potionIngredientsBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder itemsByModIdBuilder = ImmutableListMultimap.builder();
        for (ItemStack itemStack : this.getIngredients(ItemStack.class)) {
            String itemStackInfo;
            String modId = itemStackHelper.getModId(itemStack).toLowerCase(Locale.ENGLISH);
            itemsByModIdBuilder.put((Object)modId, (Object)itemStack);
            try {
                if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                    fuelsBuilder.add((Object)itemStack);
                }
            }
            catch (RuntimeException e) {
                itemStackInfo = itemStackHelper.getErrorInfo(itemStack);
                Log.error("Failed to check if item is fuel {}.", itemStackInfo, e);
            }
            catch (LinkageError e) {
                itemStackInfo = itemStackHelper.getErrorInfo(itemStack);
                Log.error("Failed to check if item is fuel {}.", itemStackInfo, e);
            }
            try {
                if (!PotionHelper.func_185205_a((ItemStack)itemStack)) continue;
                potionIngredientsBuilder.add((Object)itemStack);
            }
            catch (RuntimeException e) {
                itemStackInfo = itemStackHelper.getErrorInfo(itemStack);
                Log.error("Failed to check if item is a potion ingredient {}.", itemStackInfo, e);
            }
            catch (LinkageError e) {
                itemStackInfo = itemStackHelper.getErrorInfo(itemStack);
                Log.error("Failed to check if item is a potion ingredient {}.", itemStackInfo, e);
            }
        }
        this.fuels = fuelsBuilder.build();
        this.potionIngredients = potionIngredientsBuilder.build();
    }

    @Override
    public <V> ImmutableList<V> getIngredients(@Nullable Class<V> ingredientClass) {
        if (ingredientClass == null) {
            Log.error("Null ingredientClass", new NullPointerException());
            return ImmutableList.of();
        }
        ImmutableList ingredients = (ImmutableList)this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return ImmutableList.of();
        }
        return ingredients;
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        return this.getIngredientHelper(ingredient.getClass());
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(Class<V> ingredientClass) {
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientClass);
        if (ingredientHelper == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientClass);
        }
        return ingredientHelper;
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientRenderer(ingredientClass);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(Class<V> ingredientClass) {
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientClass);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientClass);
        }
        return ingredientRenderer;
    }

    @Override
    public ImmutableCollection<Class> getRegisteredIngredientClasses() {
        return this.ingredientsMap.keySet();
    }

    @Override
    public ImmutableList<ItemStack> getFuels() {
        return this.fuels;
    }

    @Override
    public ImmutableList<ItemStack> getPotionIngredients() {
        return this.potionIngredients;
    }
}

