/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.IngredientUtil;
import mezz.jei.util.RecipeMap;

public class InternalRecipeRegistryPlugin
implements IRecipeRegistryPlugin {
    private RecipeRegistry recipeRegistry;
    private ImmutableMultimap<String, String> categoriesForCraftItemKeys;
    private IIngredientRegistry ingredientRegistry;
    private ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private RecipeMap recipeInputMap;
    private RecipeMap recipeOutputMap;
    private ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories;

    public InternalRecipeRegistryPlugin(RecipeRegistry recipeRegistry, ImmutableMultimap<String, String> categoriesForCraftItemKeys, IIngredientRegistry ingredientRegistry, ImmutableMap<String, IRecipeCategory> recipeCategoriesMap, RecipeMap recipeInputMap, RecipeMap recipeOutputMap, ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories) {
        this.recipeRegistry = recipeRegistry;
        this.categoriesForCraftItemKeys = categoriesForCraftItemKeys;
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = recipeCategoriesMap;
        this.recipeInputMap = recipeInputMap;
        this.recipeOutputMap = recipeOutputMap;
        this.recipeWrappersForCategories = recipeWrappersForCategories;
    }

    @Override
    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getMode() == IFocus.Mode.NONE) {
            return this.getRecipeCategories();
        }
        V ingredient = focus.getValue();
        if (ingredient == null) {
            return this.getRecipeCategories();
        }
        switch (focus.getMode()) {
            case INPUT: {
                return this.recipeInputMap.getRecipeCategories(ingredient);
            }
            case OUTPUT: {
                return this.recipeOutputMap.getRecipeCategories(ingredient);
            }
        }
        return this.getRecipeCategories();
    }

    private ImmutableList<String> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.recipeCategoriesMap.entrySet()) {
            IRecipeCategory recipeCategory = (IRecipeCategory)entry.getValue();
            if (this.recipeRegistry.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            builder.add(entry.getKey());
        }
        return builder.build();
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (focus.getMode() == IFocus.Mode.NONE) {
            return this.getRecipeWrappers(recipeCategory);
        }
        V ingredient = focus.getValue();
        if (ingredient == null) {
            return this.getRecipeWrappers(recipeCategory);
        }
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        if (focus.getMode() == IFocus.Mode.INPUT) {
            ImmutableList<T> recipes = this.recipeInputMap.getRecipeWrappers(recipeCategory, ingredient);
            String recipeCategoryUid = recipeCategory.getUid();
            for (String inputKey : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
                if (!this.categoriesForCraftItemKeys.get((Object)inputKey).contains((Object)recipeCategoryUid)) continue;
                ImmutableSet specificRecipes = ImmutableSet.copyOf(recipes);
                List recipesForCategory = this.recipeWrappersForCategories.get(recipeCategory);
                ArrayList<T> allRecipes = new ArrayList<T>(recipes);
                for (IRecipeWrapper recipe : recipesForCategory) {
                    if (specificRecipes.contains((Object)recipe)) continue;
                    allRecipes.add(recipe);
                }
                return allRecipes;
            }
            return recipes;
        }
        if (focus.getMode() == IFocus.Mode.OUTPUT) {
            return this.recipeOutputMap.getRecipeWrappers(recipeCategory, ingredient);
        }
        return this.getRecipeWrappers(recipeCategory);
    }

    private <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        List recipeWrappers = this.recipeWrappersForCategories.get(recipeCategory);
        return Collections.unmodifiableList(recipeWrappers);
    }
}

