/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.Iterator;
import java.util.List;
import mezz.jei.IngredientRegistry;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.ItemRegistry;
import mezz.jei.ItemRegistryFactory;
import mezz.jei.JeiHelpers;
import mezz.jei.JeiRuntime;
import mezz.jei.ModIngredientRegistration;
import mezz.jei.RecipeRegistry;
import mezz.jei.SubtypeRegistry;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.util.Log;
import mezz.jei.util.ModIdUtil;
import mezz.jei.util.ModRegistry;
import mezz.jei.util.StackHelper;

public class JeiStarter {
    public static JeiRuntime startJEI(List<IModPlugin> plugins) {
        SubtypeRegistry subtypeRegistry = new SubtypeRegistry();
        JeiStarter.registerItemSubtypes(plugins, subtypeRegistry);
        StackHelper stackHelper = new StackHelper(subtypeRegistry);
        stackHelper.enableUidCache();
        Internal.setStackHelper(stackHelper);
        IngredientRegistry ingredientRegistry = JeiStarter.registerIngredients(plugins);
        Internal.setIngredientRegistry(ingredientRegistry);
        JeiHelpers jeiHelpers = new JeiHelpers(ingredientRegistry, stackHelper, subtypeRegistry);
        Internal.setHelpers(jeiHelpers);
        ModIdUtil modIdUtil = Internal.getModIdUtil();
        ItemRegistry itemRegistry = ItemRegistryFactory.createItemRegistry(ingredientRegistry, modIdUtil);
        ModRegistry modRegistry = new ModRegistry(jeiHelpers, itemRegistry, ingredientRegistry);
        JeiStarter.registerPlugins(plugins, modRegistry);
        Log.info("Building recipe registry...", new Object[0]);
        long start_time = System.currentTimeMillis();
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry(stackHelper, ingredientRegistry);
        Log.info("Built    recipe registry in {} ms", System.currentTimeMillis() - start_time);
        ItemFilter itemFilter = new ItemFilter();
        itemFilter.build(ingredientRegistry, jeiHelpers);
        Log.info("Building runtime...", new Object[0]);
        start_time = System.currentTimeMillis();
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        ItemListOverlay itemListOverlay = new ItemListOverlay(itemFilter, advancedGuiHandlers, ingredientRegistry);
        RecipesGui recipesGui = new RecipesGui(recipeRegistry);
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, itemListOverlay, recipesGui, ingredientRegistry);
        Internal.setRuntime(jeiRuntime);
        Log.info("Built    runtime in {} ms", System.currentTimeMillis() - start_time);
        stackHelper.disableUidCache();
        JeiStarter.sendRuntime(plugins, jeiRuntime);
        return jeiRuntime;
    }

    private static void registerItemSubtypes(List<IModPlugin> plugins, SubtypeRegistry subtypeRegistry) {
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.registerItemSubtypes(subtypeRegistry);
            }
            catch (RuntimeException e) {
                Log.error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
    }

    private static IngredientRegistry registerIngredients(List<IModPlugin> plugins) {
        ModIngredientRegistration modIngredientRegistry = new ModIngredientRegistration();
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.registerIngredients(modIngredientRegistry);
            }
            catch (RuntimeException e) {
                Log.error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        return modIngredientRegistry.createIngredientRegistry();
    }

    private static void registerPlugins(List<IModPlugin> plugins, ModRegistry modRegistry) {
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                long start_time = System.currentTimeMillis();
                Log.info("Registering plugin: {} ...", plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.info("Registered  plugin: {} in {} ms", plugin.getClass().getName(), timeElapsedMs);
            }
            catch (RuntimeException e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
    }

    private static void sendRuntime(List<IModPlugin> plugins, IJeiRuntime jeiRuntime) {
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                long start_time = System.currentTimeMillis();
                Log.info("Sending runtime to plugin: {} ...", plugin.getClass().getName());
                plugin.onRuntimeAvailable(jeiRuntime);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.info("Sent    runtime to plugin: {} in {} ms", plugin.getClass().getName(), timeElapsedMs);
            }
            catch (RuntimeException e) {
                Log.error("Sending runtime to plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Sending runtime to plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
    }
}

