/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.GuiEventHandler;
import mezz.jei.IngredientRegistry;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.JeiHelpers;
import mezz.jei.JeiRuntime;
import mezz.jei.JeiStarter;
import mezz.jei.ProxyCommon;
import mezz.jei.api.IModPlugin;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.SessionData;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.network.packets.PacketJEI;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyCommonClient
extends ProxyCommon {
    @Nullable
    private GuiEventHandler guiEventHandler;
    private List<IModPlugin> plugins;

    private static void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "just-enough-items-jei");
        compound.func_74778_a("curseFilenameParser", "jei_1.10.2-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)"JEI", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        IModPlugin jeiInternalPlugin;
        Config.preInit(event);
        ProxyCommonClient.initVersionChecker();
        ASMDataTable asmDataTable = event.getAsmData();
        this.plugins = AnnotatedInstanceUtil.getModPlugins(asmDataTable);
        IModPlugin vanillaPlugin = this.getVanillaPlugin(this.plugins);
        if (vanillaPlugin != null) {
            this.plugins.remove(vanillaPlugin);
            this.plugins.add(0, vanillaPlugin);
        }
        if ((jeiInternalPlugin = this.getJeiInternalPlugin(this.plugins)) != null) {
            this.plugins.remove(jeiInternalPlugin);
            this.plugins.add(jeiInternalPlugin);
        }
    }

    @Nullable
    private IModPlugin getVanillaPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof VanillaPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Nullable
    private IModPlugin getJeiInternalPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof JEIInternalPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_110442_L();
        reloadableResourceManager.func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                ProxyCommonClient.this.restartJEI();
            }
        });
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && !SessionData.isJeiStarted() && Minecraft.func_71410_x().field_71439_g != null) {
            try {
                this.startJEI();
            }
            catch (Throwable e) {
                Minecraft.func_71410_x().func_71377_b(new CrashReport("JEI failed to start:", e));
            }
        }
    }

    private void startJEI() {
        long jeiStartTime = System.currentTimeMillis();
        Log.info("Beginning startup...", new Object[0]);
        SessionData.setJeiStarted();
        Config.startJei();
        JeiRuntime jeiRuntime = JeiStarter.startJEI(this.plugins);
        if (this.guiEventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.guiEventHandler);
            this.guiEventHandler = null;
        }
        this.guiEventHandler = new GuiEventHandler(jeiRuntime);
        MinecraftForge.EVENT_BUS.register((Object)this.guiEventHandler);
        Log.info("Finished startup in {} ms", System.currentTimeMillis() - jeiStartTime);
    }

    @Override
    public void restartJEI() {
        if (SessionData.isJeiStarted()) {
            this.startJEI();
        }
    }

    private static void reloadItemList() {
        JeiRuntime runtime;
        if (SessionData.isJeiStarted() && (runtime = Internal.getRuntime()) != null) {
            ItemListOverlay itemListOverlay = runtime.getItemListOverlay();
            ItemFilter itemFilter = itemListOverlay.getItemFilter();
            IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
            JeiHelpers helpers = Internal.getHelpers();
            itemFilter.build(ingredientRegistry, helpers);
        }
    }

    @Override
    public void sendPacketToServer(PacketJEI packet) {
        NetHandlerPlayClient netHandler = FMLClientHandler.instance().getClient().func_147114_u();
        if (netHandler != null) {
            netHandler.func_147297_a((Packet)packet.getPacket());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (!"JEI".equals(eventArgs.getModID())) {
            return;
        }
        if (Config.syncAllConfig()) {
            ProxyCommonClient.reloadItemList();
        }
    }
}

