/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.config.SessionData;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import mezz.jei.util.color.ColorGetter;
import mezz.jei.util.color.ColorNamer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config {
    private static final String configKeyPrefix = "config.jei";
    private static File jeiConfigurationDir;
    public static final String CATEGORY_SEARCH = "search";
    public static final String CATEGORY_ADVANCED = "advanced";
    public static final String CATEGORY_SEARCH_COLORS = "searchColors";
    private static LocalizedConfiguration config;
    @Nullable
    private static Configuration worldConfig;
    private static LocalizedConfiguration itemBlacklistConfig;
    private static LocalizedConfiguration searchColorsConfig;
    private static boolean debugModeEnabled;
    private static boolean debugItemEnabled;
    private static boolean hideMissingModelsEnabled;
    private static boolean colorSearchEnabled;
    private static boolean centerSearchBarEnabled;
    private static boolean prefixRequiredForModNameSearch;
    private static boolean prefixRequiredForTooltipSearch;
    private static boolean prefixRequiredForOreDictSearch;
    private static boolean prefixRequiredForCreativeTabSearch;
    private static boolean prefixRequiredForColorSearch;
    private static final boolean defaultOverlayEnabled = true;
    private static final boolean defaultCheatItemsEnabled = false;
    private static final boolean defaultEditModeEnabled = false;
    private static final String defaultFilterText = "";
    private static boolean overlayEnabled;
    private static boolean cheatItemsEnabled;
    private static boolean editModeEnabled;
    private static String filterText;
    private static final Set<String> itemBlacklist;
    private static final String[] defaultItemBlacklist;

    private Config() {
    }

    public static boolean isOverlayEnabled() {
        return overlayEnabled;
    }

    public static void toggleOverlayEnabled() {
        boolean bl = overlayEnabled = !overlayEnabled;
        if (worldConfig != null) {
            String worldCategory = SessionData.getWorldUid();
            Property property = worldConfig.get(worldCategory, "overlayEnabled", overlayEnabled);
            property.set(overlayEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
    }

    public static boolean isCheatItemsEnabled() {
        return cheatItemsEnabled;
    }

    public static void toggleCheatItemsEnabled() {
        cheatItemsEnabled = !cheatItemsEnabled;
    }

    public static boolean isEditModeEnabled() {
        return editModeEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return debugModeEnabled;
    }

    public static boolean isDebugItemEnabled() {
        return debugItemEnabled;
    }

    public static boolean isDeleteItemsInCheatModeActive() {
        return cheatItemsEnabled && SessionData.isJeiOnServer();
    }

    public static boolean isHideMissingModelsEnabled() {
        return hideMissingModelsEnabled;
    }

    public static boolean isColorSearchEnabled() {
        return colorSearchEnabled;
    }

    public static boolean isCenterSearchBarEnabled() {
        return centerSearchBarEnabled;
    }

    public static boolean isPrefixRequiredForModNameSearch() {
        return prefixRequiredForModNameSearch;
    }

    public static boolean isPrefixRequiredForTooltipSearch() {
        return prefixRequiredForTooltipSearch;
    }

    public static boolean isPrefixRequiredForOreDictSearch() {
        return prefixRequiredForOreDictSearch;
    }

    public static boolean isPrefixRequiredForCreativeTabSearch() {
        return prefixRequiredForCreativeTabSearch;
    }

    public static boolean isPrefixRequiredForColorSearch() {
        return prefixRequiredForColorSearch;
    }

    public static boolean setFilterText(String filterText) {
        String lowercaseFilterText = filterText.toLowerCase();
        if (Config.filterText.equals(lowercaseFilterText)) {
            return false;
        }
        Config.filterText = lowercaseFilterText;
        return true;
    }

    public static String getFilterText() {
        return filterText;
    }

    public static void saveFilterText() {
        if (worldConfig != null) {
            String worldCategory = SessionData.getWorldUid();
            Property property = worldConfig.get(worldCategory, "filterText", defaultFilterText);
            property.set(filterText);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
    }

    public static LocalizedConfiguration getConfig() {
        return config;
    }

    @Nullable
    public static Configuration getWorldConfig() {
        return worldConfig;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        File oldItemBlacklistConfigFile;
        jeiConfigurationDir = new File(event.getModConfigurationDirectory(), "JEI");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    Log.error("Could not create config directory {}", jeiConfigurationDir);
                    return;
                }
            }
            catch (SecurityException e) {
                Log.error("Could not create config directory {}", jeiConfigurationDir, e);
                return;
            }
        }
        File configFile = new File(jeiConfigurationDir, "jei.cfg");
        File itemBlacklistConfigFile = new File(jeiConfigurationDir, "itemBlacklist.cfg");
        File searchColorsConfigFile = new File(jeiConfigurationDir, "searchColors.cfg");
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            try {
                if (!oldConfigFile.renameTo(configFile)) {
                    Log.error("Could not move old config file {}", oldConfigFile);
                }
            }
            catch (SecurityException e) {
                Log.error("Could not move old config file {}", oldConfigFile, e);
            }
        }
        if ((oldItemBlacklistConfigFile = new File(event.getModConfigurationDirectory(), "JEI-itemBlacklist.cfg")).exists()) {
            try {
                if (!oldItemBlacklistConfigFile.renameTo(itemBlacklistConfigFile)) {
                    Log.error("Could not move old config file {}", oldItemBlacklistConfigFile);
                }
            }
            catch (SecurityException e) {
                Log.error("Could not move old config file {}", oldItemBlacklistConfigFile, e);
            }
        }
        config = new LocalizedConfiguration(configKeyPrefix, configFile, "0.2.0");
        itemBlacklistConfig = new LocalizedConfiguration(configKeyPrefix, itemBlacklistConfigFile, "0.1.0");
        searchColorsConfig = new LocalizedConfiguration(configKeyPrefix, searchColorsConfigFile, "0.1.0");
        Config.syncConfig();
        Config.syncItemBlacklistConfig();
    }

    public static void startJei() {
        File worldConfigFile = new File(jeiConfigurationDir, "worldSettings.cfg");
        worldConfig = new Configuration(worldConfigFile, "0.1.0");
        Config.syncWorldConfig();
        Config.syncSearchColorsConfig();
    }

    public static boolean syncAllConfig() {
        boolean needsReload = false;
        if (Config.syncConfig()) {
            needsReload = true;
        }
        if (Config.syncItemBlacklistConfig()) {
            needsReload = true;
        }
        if (Config.syncWorldConfig()) {
            needsReload = true;
        }
        if (Config.syncSearchColorsConfig()) {
            needsReload = true;
        }
        return needsReload;
    }

    private static boolean syncConfig() {
        boolean configChanged;
        ConfigCategory interfaceCategory;
        ConfigCategory addonsCategory;
        boolean needsReload = false;
        config.addCategory(CATEGORY_SEARCH);
        config.addCategory(CATEGORY_ADVANCED);
        ConfigCategory modeCategory = config.getCategory("mode");
        if (modeCategory != null) {
            config.removeCategory(modeCategory);
        }
        if ((addonsCategory = config.getCategory("addons")) != null) {
            config.removeCategory(addonsCategory);
        }
        if ((interfaceCategory = config.getCategory("interface")) != null) {
            config.removeCategory(interfaceCategory);
        }
        prefixRequiredForModNameSearch = config.getBoolean(CATEGORY_SEARCH, "atPrefixRequiredForModName", prefixRequiredForModNameSearch);
        prefixRequiredForTooltipSearch = config.getBoolean(CATEGORY_SEARCH, "prefixRequiredForTooltipSearch", prefixRequiredForTooltipSearch);
        prefixRequiredForOreDictSearch = config.getBoolean(CATEGORY_SEARCH, "prefixRequiredForOreDictSearch", prefixRequiredForOreDictSearch);
        prefixRequiredForCreativeTabSearch = config.getBoolean(CATEGORY_SEARCH, "prefixRequiredForCreativeTabSearch", prefixRequiredForCreativeTabSearch);
        prefixRequiredForColorSearch = config.getBoolean(CATEGORY_SEARCH, "prefixRequiredForColorSearch", prefixRequiredForColorSearch);
        if (config.getCategory(CATEGORY_SEARCH).hasChanged()) {
            needsReload = true;
        }
        ConfigCategory categoryAdvanced = config.getCategory(CATEGORY_ADVANCED);
        categoryAdvanced.remove((Object)"nbtKeyIgnoreList");
        categoryAdvanced.remove((Object)"deleteItemsInCheatModeEnabled");
        categoryAdvanced.remove((Object)"hideLaggyModelsEnabled");
        hideMissingModelsEnabled = config.getBoolean(CATEGORY_ADVANCED, "hideMissingModelsEnabled", hideMissingModelsEnabled);
        if (categoryAdvanced.get("hideMissingModelsEnabled").hasChanged()) {
            needsReload = true;
        }
        colorSearchEnabled = config.getBoolean(CATEGORY_ADVANCED, "colorSearchEnabled", colorSearchEnabled);
        if (categoryAdvanced.get("colorSearchEnabled").hasChanged()) {
            needsReload = true;
        }
        centerSearchBarEnabled = config.getBoolean(CATEGORY_ADVANCED, "centerSearchBarEnabled", centerSearchBarEnabled);
        debugModeEnabled = config.getBoolean(CATEGORY_ADVANCED, "debugModeEnabled", debugModeEnabled);
        Property property = config.get(CATEGORY_ADVANCED, "debugModeEnabled", debugModeEnabled);
        property.setShowInGui(false);
        debugItemEnabled = config.getBoolean(CATEGORY_ADVANCED, "debugItemEnabled", debugItemEnabled);
        property = config.get(CATEGORY_ADVANCED, "debugItemEnabled", debugItemEnabled);
        property.setShowInGui(false);
        property.setRequiresMcRestart(true);
        if (config.hasKey(CATEGORY_ADVANCED, "itemBlacklist")) {
            Property oldItemBlacklistProperty = config.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
            String[] itemBlacklistArray = oldItemBlacklistProperty.getStringList();
            Property newItemBlacklistProperty = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
            newItemBlacklistProperty.set(itemBlacklistArray);
            categoryAdvanced.remove((Object)"itemBlacklist");
        }
        if (configChanged = config.hasChanged()) {
            config.save();
        }
        return needsReload;
    }

    private static boolean syncItemBlacklistConfig() {
        itemBlacklistConfig.addCategory(CATEGORY_ADVANCED);
        String[] itemBlacklistArray = itemBlacklistConfig.getStringList("itemBlacklist", CATEGORY_ADVANCED, defaultItemBlacklist);
        itemBlacklist.clear();
        Collections.addAll(itemBlacklist, itemBlacklistArray);
        boolean configChanged = itemBlacklistConfig.hasChanged();
        if (configChanged) {
            itemBlacklistConfig.save();
        }
        return configChanged;
    }

    private static boolean syncWorldConfig() {
        if (worldConfig == null) {
            return false;
        }
        boolean needsReload = false;
        String worldCategory = SessionData.getWorldUid();
        Property property = worldConfig.get(worldCategory, "overlayEnabled", true);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        overlayEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "cheatItemsEnabled", false);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        cheatItemsEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "editEnabled", false);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        editModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            needsReload = true;
        }
        property = worldConfig.get(worldCategory, "filterText", defaultFilterText);
        property.setShowInGui(false);
        filterText = property.getString();
        boolean configChanged = worldConfig.hasChanged();
        if (configChanged) {
            worldConfig.save();
        }
        return needsReload;
    }

    private static boolean syncSearchColorsConfig() {
        searchColorsConfig.addCategory(CATEGORY_SEARCH_COLORS);
        String[] searchColorDefaults = ColorGetter.getColorDefaults();
        String[] searchColors = searchColorsConfig.getStringList(CATEGORY_SEARCH_COLORS, CATEGORY_SEARCH_COLORS, searchColorDefaults);
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                Log.error("Invalid format for searchColor entry: {}", entry);
                continue;
            }
            try {
                String name = values[0];
                int colorValue = Integer.decode("0x" + values[1]);
                Color color = new Color(colorValue);
                searchColorsMapBuilder.put((Object)color, (Object)name);
            }
            catch (NumberFormatException e) {
                Log.error("Invalid number format for searchColor entry: {}", entry, e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Color, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
        boolean configChanged = searchColorsConfig.hasChanged();
        if (configChanged) {
            searchColorsConfig.save();
        }
        return configChanged;
    }

    private static boolean updateBlacklist() {
        Property property = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
        String[] currentBlacklist = itemBlacklist.toArray(new String[itemBlacklist.size()]);
        property.set(currentBlacklist);
        boolean changed = itemBlacklistConfig.hasChanged();
        if (changed) {
            itemBlacklistConfig.save();
        }
        return changed;
    }

    public static <V> void addIngredientToConfigBlacklist(V itemStack, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(itemStack, blacklistType, ingredientHelper);
        if (itemBlacklist.add(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> void removeIngredientFromConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        if (itemBlacklist.remove(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!Config.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return itemBlacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
            case MOD_ID: {
                return ingredientHelper.getModId(ingredient);
            }
        }
        return defaultFilterText;
    }

    static {
        debugModeEnabled = false;
        debugItemEnabled = false;
        hideMissingModelsEnabled = true;
        colorSearchEnabled = false;
        centerSearchBarEnabled = false;
        prefixRequiredForModNameSearch = true;
        prefixRequiredForTooltipSearch = false;
        prefixRequiredForOreDictSearch = true;
        prefixRequiredForCreativeTabSearch = true;
        prefixRequiredForColorSearch = true;
        overlayEnabled = true;
        cheatItemsEnabled = false;
        editModeEnabled = false;
        filterText = defaultFilterText;
        itemBlacklist = new HashSet<String>();
        defaultItemBlacklist = new String[0];
    }

    public static enum IngredientBlacklistType {
        ITEM,
        WILDCARD,
        MOD_ID;

        public static final IngredientBlacklistType[] VALUES;

        static {
            VALUES = IngredientBlacklistType.values();
        }
    }
}

