/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;

public class CraftingGridHelper
implements ICraftingGridHelper {
    private final IStackHelper stackHelper;
    private final int craftInputSlot1;
    private final int craftOutputSlot;

    public CraftingGridHelper(IStackHelper stackHelper, int craftInputSlot1, int craftOutputSlot) {
        this.stackHelper = stackHelper;
        this.craftInputSlot1 = craftInputSlot1;
        this.craftOutputSlot = craftOutputSlot;
    }

    @Override
    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input) {
        int width;
        int height;
        if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputStacks(guiItemStacks, input, width, height);
    }

    @Override
    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            List<ItemStack> recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(guiItemStacks, index, recipeItem);
        }
    }

    @Override
    @Deprecated
    public void setInput(IGuiItemStackGroup guiItemStacks, List input) {
        int width;
        int height;
        if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInput(guiItemStacks, input, width, height);
    }

    @Override
    @Deprecated
    public void setInput(IGuiItemStackGroup guiItemStacks, List input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            Object recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            List<ItemStack> itemStacks = this.stackHelper.toItemStackList(recipeItem);
            this.setInput(guiItemStacks, index, itemStacks);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 4 : 4);
        } else if (height == 1) {
            index = i + 6;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    @Override
    public void setOutput(IGuiItemStackGroup guiItemStacks, List<ItemStack> output) {
        guiItemStacks.set(this.craftOutputSlot, output);
    }

    private void setInput(IGuiItemStackGroup guiItemStacks, int inputIndex, Collection<ItemStack> input) {
        guiItemStacks.set(this.craftInputSlot1 + inputIndex, input);
    }
}

