/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.RecipeTransferButton;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiIngredientGroup;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.Ingredients;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLayout
implements IRecipeLayout {
    private static final int RECIPE_BUTTON_SIZE = 12;
    public static final int recipeTransferButtonIndex = 100;
    private final IRecipeCategory recipeCategory;
    private final GuiItemStackGroup guiItemStackGroup;
    private final GuiFluidStackGroup guiFluidStackGroup;
    private final Map<Class, GuiIngredientGroup> guiIngredientGroups;
    private final RecipeTransferButton recipeTransferButton;
    private final IRecipeWrapper recipeWrapper;
    private final IFocus<?> focus;
    private final int posX;
    private final int posY;

    public <T extends IRecipeWrapper> RecipeLayout(int index, int posX, int posY, IRecipeCategory<T> recipeCategory, T recipeWrapper, IFocus focus) {
        this.recipeCategory = recipeCategory;
        this.focus = focus;
        ItemStack itemStackFocus = null;
        FluidStack fluidStackFocus = null;
        Object focusValue = focus.getValue();
        if (focusValue instanceof ItemStack) {
            itemStackFocus = (ItemStack)focusValue;
        } else if (focusValue instanceof FluidStack) {
            fluidStackFocus = (FluidStack)focusValue;
        }
        this.guiItemStackGroup = new GuiItemStackGroup(new Focus<ItemStack>(focus.getMode(), itemStackFocus));
        this.guiFluidStackGroup = new GuiFluidStackGroup(new Focus<FluidStack>(focus.getMode(), fluidStackFocus));
        this.guiIngredientGroups = new HashMap<Class, GuiIngredientGroup>();
        this.guiIngredientGroups.put(ItemStack.class, this.guiItemStackGroup);
        this.guiIngredientGroups.put(FluidStack.class, this.guiFluidStackGroup);
        int width = recipeCategory.getBackground().getWidth();
        int height = recipeCategory.getBackground().getHeight();
        this.recipeTransferButton = new RecipeTransferButton(100 + index, posX + width + 2, posY + height - 12, 12, 12, "+");
        this.posX = posX;
        this.posY = posY;
        this.recipeWrapper = recipeWrapper;
        try {
            try {
                Ingredients ingredients = new Ingredients();
                recipeWrapper.getIngredients(ingredients);
                recipeCategory.setRecipe(this, recipeWrapper, ingredients);
            }
            catch (AbstractMethodError ignored) {
                recipeCategory.setRecipe(this, recipeWrapper);
            }
        }
        catch (RuntimeException e) {
            Log.error("Error caught from Recipe Category: {}", recipeCategory.getClass().getCanonicalName(), e);
        }
        catch (LinkageError e) {
            Log.error("Error caught from Recipe Category: {}", recipeCategory.getClass().getCanonicalName(), e);
        }
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        List<String> tooltipStrings;
        IDrawable background = this.recipeCategory.getBackground();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        this.recipeCategory.drawAnimations(minecraft);
        this.recipeWrapper.drawAnimations(minecraft, background.getWidth(), background.getHeight());
        GlStateManager.func_179121_F();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight(), recipeMouseX, recipeMouseY);
        GlStateManager.func_179121_F();
        GuiIngredient hoveredIngredient = null;
        for (GuiIngredientGroup guiIngredientGroup : this.guiIngredientGroups.values()) {
            GuiIngredient hovered = guiIngredientGroup.draw(minecraft, this.posX, this.posY, mouseX, mouseY);
            if (hovered == null) continue;
            hoveredIngredient = hovered;
        }
        this.recipeTransferButton.func_146112_a(minecraft, mouseX, mouseY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        if (hoveredIngredient != null) {
            hoveredIngredient.drawHovered(minecraft, this.posX, this.posY, recipeMouseX, recipeMouseY);
        } else if (this.isMouseOver(mouseX, mouseY) && (tooltipStrings = this.recipeWrapper.getTooltipStrings(recipeMouseX, recipeMouseY)) != null && !tooltipStrings.isEmpty()) {
            TooltipRenderer.drawHoveringText(minecraft, tooltipStrings, mouseX, mouseY);
        }
        GlStateManager.func_179118_c();
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        IDrawable background = this.recipeCategory.getBackground();
        return recipeMouseX >= 0 && recipeMouseX < background.getWidth() && recipeMouseY >= 0 && recipeMouseY < background.getHeight();
    }

    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IClickedIngredient clicked = this.guiItemStackGroup.getIngredientUnderMouse(this.posX, this.posY, mouseX, mouseY);
        if (clicked == null) {
            clicked = this.guiFluidStackGroup.getIngredientUnderMouse(this.posX, this.posY, mouseX, mouseY);
        }
        return clicked;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return this.recipeWrapper.handleClick(minecraft, mouseX - this.posX, mouseY - this.posY, mouseButton);
    }

    @Override
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    public IGuiFluidStackGroup getFluidStacks() {
        return this.guiFluidStackGroup;
    }

    @Override
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(Class<T> ingredientClass) {
        GuiIngredientGroup<Object> guiIngredientGroup = this.guiIngredientGroups.get(ingredientClass);
        if (guiIngredientGroup == null) {
            Object value = null;
            Object focusValue = this.focus.getValue();
            if (ingredientClass.isInstance(focusValue)) {
                value = focusValue;
            }
            Focus<Object> focus = new Focus<Object>(this.focus.getMode(), value);
            guiIngredientGroup = new GuiIngredientGroup<Object>(ingredientClass, focus);
            this.guiIngredientGroups.put(ingredientClass, guiIngredientGroup);
        }
        return guiIngredientGroup;
    }

    @Override
    public void setRecipeTransferButton(int posX, int posY) {
        this.recipeTransferButton.field_146128_h = posX + this.posX;
        this.recipeTransferButton.field_146129_i = posY + this.posY;
    }

    @Override
    public IFocus<?> getFocus() {
        return this.focus;
    }

    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    public IRecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    public IRecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

