/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.debug;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DebugRecipeRegistryPlugin
implements IRecipeRegistryPlugin {
    @Override
    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        V focusValue = focus.getValue();
        if (focusValue instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)focusValue;
            Item item = itemStack.func_77973_b();
            switch (focus.getMode()) {
                case INPUT: {
                    if (item != Items.field_179564_cE && !HorseArmorType.func_188577_b((Item)item)) break;
                    return Collections.singletonList("minecraft.brewing");
                }
                case OUTPUT: {
                    if (item == Item.func_150898_a((Block)Blocks.field_150484_ah)) {
                        return Collections.singletonList("minecraft.brewing");
                    }
                }
                case NONE: {
                    return Collections.singletonList("minecraft.brewing");
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (recipeCategory.getUid().equals("minecraft.brewing")) {
            List<ItemStack> potionIngredients = null;
            ItemStack potionInput = new ItemStack(Items.field_151125_bZ);
            ItemStack potionOutput = new ItemStack(Blocks.field_150484_ah);
            IFocus.Mode focusMode = focus.getMode();
            if (focusMode != IFocus.Mode.NONE) {
                V focusValue = focus.getValue();
                if (focusValue instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)focusValue;
                    Item item = itemStack.func_77973_b();
                    if (focusMode == IFocus.Mode.INPUT) {
                        if (item == Items.field_179564_cE) {
                            potionIngredients = Collections.singletonList(itemStack);
                        } else if (HorseArmorType.func_188577_b((Item)item)) {
                            potionInput = itemStack;
                        }
                    } else if (focusMode == IFocus.Mode.OUTPUT && item == Item.func_150898_a((Block)Blocks.field_150484_ah)) {
                        potionOutput = itemStack;
                    }
                } else {
                    return Collections.emptyList();
                }
            }
            if (potionIngredients == null) {
                ItemStack blackBanner = new ItemStack(Items.field_179564_cE, 1, Short.MAX_VALUE);
                potionIngredients = JEIInternalPlugin.jeiHelpers.getStackHelper().getSubtypes(blackBanner);
            }
            return Collections.singletonList(new BrewingRecipeWrapper(potionIngredients, potionInput, potionOutput, 100));
        }
        return Collections.emptyList();
    }
}

