/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.util.InventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandlerServer {
    public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        Container container = player.field_71070_bA;
        HashMap slotMap = new HashMap(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.func_75139_a(entry.getValue().intValue());
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack == null) {
                return;
            }
            ItemStack itemStack = slotStack.func_77946_l();
            itemStack.field_77994_a = 1;
            slotMap.put(entry.getKey(), itemStack);
        }
        int maxRemovedSets = maxTransfer ? 64 : 1;
        for (Map.Entry entry : slotMap.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_77985_e()) {
                Integer n = (Integer)entry.getKey();
                Integer slotNumber = craftingSlots.get(n);
                Slot craftSlot = container.func_75139_a(slotNumber.intValue());
                int maxStackSize = Math.min(craftSlot.func_178170_b(stack), stack.func_77976_d());
                maxRemovedSets = Math.min(maxRemovedSets, maxStackSize);
                continue;
            }
            maxRemovedSets = 1;
        }
        if (maxRemovedSets <= 0) {
            return;
        }
        int removedSets = BasicRecipeTransferHandlerServer.removeSetsFromInventory(container, slotMap.values(), craftingSlots, inventorySlots, maxRemovedSets);
        if (removedSets == 0) {
            return;
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (Integer n : craftingSlots) {
            Slot craftingSlot = container.func_75139_a(n.intValue());
            if (!craftingSlot.func_75216_d()) continue;
            ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
            arrayList.add(craftingItem);
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            Integer craftNumber = (Integer)entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            ItemStack stack = (ItemStack)entry.getValue();
            stack.field_77994_a *= removedSets;
            if (slot.func_75214_a(stack)) {
                slot.func_75215_d(stack);
                continue;
            }
            arrayList.add(stack);
        }
        for (ItemStack itemStack : arrayList) {
            int added = InventoryHelper.addStack(container, inventorySlots, itemStack, true);
            if (added >= itemStack.field_77994_a || player.field_71071_by.func_70441_a(itemStack)) continue;
            player.func_71019_a(itemStack, false);
        }
        container.func_75142_b();
    }

    private static int removeSetsFromInventory(Container container, Collection<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, int maxRemovedSets) {
        int removedSets;
        for (removedSets = 0; removedSets < maxRemovedSets && BasicRecipeTransferHandlerServer.removeSetsFromInventory(container, required, craftingSlots, inventorySlots); ++removedSets) {
        }
        return removedSets;
    }

    private static boolean removeSetsFromInventory(Container container, Iterable<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
        for (ItemStack matchingStack : required) {
            ItemStack requiredStack = matchingStack.func_77946_l();
            while (requiredStack.field_77994_a > 0) {
                Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                if (slot == null || slot.func_75211_c() == null) {
                    for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                        ItemStack stack = (ItemStack)slotEntry.getValue();
                        ((Slot)slotEntry.getKey()).func_75215_d(stack);
                    }
                    return false;
                }
                if (!originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                }
                ItemStack removed = slot.func_75209_a(requiredStack.field_77994_a);
                requiredStack.field_77994_a -= removed.field_77994_a;
            }
        }
        return true;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = InventoryHelper.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = InventoryHelper.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }
}

