/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

public enum ModConflictContext implements IKeyConflictContext
{
    HOLDING_ROTATEABLE{

        public boolean isActive() {
            ItemStack held = ClientSide.instance.getPlayer().func_184614_ca();
            return held != null && held.func_77973_b() instanceof IVoxelBlobItem;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME || other == HOLDING_MENUITEM;
        }
    }
    ,
    HOLDING_MENUITEM{

        public boolean isActive() {
            ChiselToolType tool = ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND);
            return tool != null && tool.hasMenu();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME || other == HOLDING_POSTIVEPATTERN || other == HOLDING_CHISEL || other == HOLDING_TAPEMEASURE;
        }
    }
    ,
    HOLDING_TAPEMEASURE{

        public boolean isActive() {
            return ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND) == ChiselToolType.TAPEMEASURE;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    }
    ,
    HOLDING_POSTIVEPATTERN{

        public boolean isActive() {
            return ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND) == ChiselToolType.POSITIVEPATTERN;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    }
    ,
    HOLDING_CHISEL{

        public boolean isActive() {
            ChiselToolType tool = ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND);
            return tool != null && tool.isBitOrChisel();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    };

}

